/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.cloud;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.consul.cloud.ConsulServiceRegistryConfiguration;
import org.apache.camel.impl.cloud.AbstractServiceRegistry;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.NotRegisteredException;
import org.kiwiproject.consul.model.agent.ImmutableRegCheck;
import org.kiwiproject.consul.model.agent.ImmutableRegistration;
import org.kiwiproject.consul.model.agent.Registration;
import org.kiwiproject.consul.model.health.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulServiceRegistry
extends AbstractServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulServiceRegistry.class);
    private final Set<String> serviceList = ConcurrentHashMap.newKeySet();
    private ConsulServiceRegistryConfiguration configuration;
    private Consul client;
    private ScheduledExecutorService scheduler;

    public ConsulServiceRegistry() {
        this.configuration = new ConsulServiceRegistryConfiguration();
    }

    public ConsulServiceRegistry(ConsulServiceRegistryConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public ConsulServiceRegistryConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConsulServiceRegistryConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public String getUrl() {
        return this.configuration.getUrl();
    }

    public void setUrl(String url) {
        this.configuration.setUrl(url);
    }

    public String getDatacenter() {
        return this.configuration.getDatacenter();
    }

    public void setDatacenter(String datacenter) {
        this.configuration.setDatacenter(datacenter);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    public String getAclToken() {
        return this.configuration.getAclToken();
    }

    public void setAclToken(String aclToken) {
        this.configuration.setAclToken(aclToken);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public Duration getConnectTimeout() {
        return this.configuration.getConnectTimeout();
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.configuration.setConnectTimeout(connectTimeout);
    }

    public Duration getReadTimeout() {
        return this.configuration.getReadTimeout();
    }

    public void setReadTimeout(Duration readTimeout) {
        this.configuration.setReadTimeout(readTimeout);
    }

    public Duration getWriteTimeout() {
        return this.configuration.getWriteTimeout();
    }

    public void setWriteTimeout(Duration writeTimeout) {
        this.configuration.setWriteTimeout(writeTimeout);
    }

    public Integer getBlockSeconds() {
        return this.configuration.getBlockSeconds();
    }

    public void setBlockSeconds(Integer blockSeconds) {
        this.configuration.setBlockSeconds(blockSeconds);
    }

    public boolean isOverrideServiceHost() {
        return this.configuration.isOverrideServiceHost();
    }

    public void setOverrideServiceHost(boolean overrideServiceHost) {
        this.configuration.setOverrideServiceHost(overrideServiceHost);
    }

    public String getServiceHost() {
        return this.configuration.getServiceHost();
    }

    public void setServiceHost(String serviceHost) {
        this.configuration.setServiceHost(serviceHost);
    }

    public int getCheckTtl() {
        return this.configuration.getCheckTtl();
    }

    public void setCheckTtl(int checkTtl) {
        this.configuration.setCheckTtl(checkTtl);
    }

    public int getCheckInterval() {
        return this.configuration.getCheckInterval();
    }

    public void setCheckInterval(int checkInterval) {
        this.configuration.setCheckInterval(checkInterval);
    }

    public int getDeregisterAfter() {
        return this.configuration.getDeregisterAfter();
    }

    public void setDeregisterAfter(int deregisterAfter) {
        this.configuration.setDeregisterAfter(deregisterAfter);
    }

    public boolean isDeregisterServicesOnStop() {
        return this.configuration.isDeregisterServicesOnStop();
    }

    public void setDeregisterServicesOnStop(boolean deregisterServicesOnStop) {
        this.configuration.setDeregisterServicesOnStop(deregisterServicesOnStop);
    }

    protected void doStart() throws Exception {
        this.client = this.configuration.createConsulClient(this.getCamelContext());
        this.scheduler = this.getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "ConsulServiceRegistry");
    }

    protected void doStop() throws Exception {
        if (this.scheduler != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.scheduler);
            this.scheduler = null;
        }
        if (this.configuration.isDeregisterServicesOnStop()) {
            for (Service service : this.client.agentClient().getServices().values()) {
                try {
                    if (!this.serviceList.contains(service.getId())) continue;
                    this.client.agentClient().deregister(service.getId());
                    this.serviceList.remove(service.getId());
                }
                catch (Exception e) {
                    LOGGER.warn("Error de-registering service: " + service, (Throwable)e);
                }
            }
            this.client = null;
        }
    }

    public void register(ServiceDefinition definition) {
        if (definition.getId() == null) {
            throw new IllegalArgumentException("Service ID must be defined (definition=" + definition + ")");
        }
        if (definition.getName() == null) {
            throw new IllegalArgumentException("Service Name must be defined (definition=" + definition + ")");
        }
        ImmutableRegistration registration = ImmutableRegistration.builder().address(this.computeServiceHost(definition)).port(definition.getPort()).name(definition.getName()).id(definition.getId()).check(this.computeCheck(definition)).tags(definition.getMetadata().entrySet().stream().filter(e -> e.getValue() != null).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toList()).addTags("_consul.service.registry.id=" + this.getId()).build();
        this.client.agentClient().register((Registration)registration);
        try {
            this.client.agentClient().pass(definition.getId());
            registration.getCheck().flatMap(Registration.RegCheck::getTtl).ifPresent(ignored -> {
                LOGGER.debug("Configure service pass for: {}", (Object)definition);
                this.scheduler.scheduleAtFixedRate(() -> {
                    try {
                        if (this.serviceList.contains(definition.getId())) {
                            this.client.agentClient().pass(definition.getId());
                        }
                    }
                    catch (NotRegisteredException e) {
                        LOGGER.warn("Service with id: {} is not more registered", (Object)definition.getId());
                        this.serviceList.remove(definition.getId());
                    }
                }, this.configuration.getCheckInterval() / 2, this.configuration.getCheckInterval(), TimeUnit.SECONDS);
            });
        }
        catch (NotRegisteredException e2) {
            LOGGER.warn("There was an issue registering service: {}", (Object)definition.getId());
        }
        this.serviceList.add(definition.getId());
    }

    public void deregister(ServiceDefinition definition) {
        if (definition.getId() == null) {
            throw new IllegalArgumentException("ServiceID must be defined (definition=" + definition + ")");
        }
        this.client.agentClient().deregister(definition.getId());
        this.serviceList.remove(definition.getId());
    }

    private String computeServiceHost(ServiceDefinition definition) {
        String host = definition.getHost();
        if (this.configuration.isOverrideServiceHost() && this.configuration.getServiceHost() != null) {
            host = this.configuration.getServiceHost();
        }
        return (String)ObjectHelper.notNull((Object)host, (String)"service host");
    }

    private Registration.RegCheck computeCheck(ServiceDefinition definition) {
        if (definition.getHealth() == null) {
            return ImmutableRegCheck.builder().ttl(String.format("%ss", this.configuration.getCheckInterval())).deregisterCriticalServiceAfter(String.format("%ss", this.configuration.getDeregisterAfter())).build();
        }
        return (Registration.RegCheck)definition.getHealth().getEndpoint().flatMap(uri -> {
            if (Objects.equals("http", uri.getScheme())) {
                return Optional.of(ImmutableRegCheck.builder().http(uri.toASCIIString()).interval(String.format("%ss", this.configuration.getCheckInterval())).deregisterCriticalServiceAfter(String.format("%ss", this.configuration.getDeregisterAfter())).build());
            }
            if (Objects.equals("https", uri.getScheme())) {
                return Optional.of(ImmutableRegCheck.builder().http(uri.toASCIIString()).interval(String.format("%ss", this.configuration.getCheckInterval())).deregisterCriticalServiceAfter(String.format("%ss", this.configuration.getDeregisterAfter())).build());
            }
            if (Objects.equals("tcp", uri.getScheme())) {
                return Optional.of(ImmutableRegCheck.builder().tcp(uri.getHost()).interval(String.format("%ss", this.configuration.getCheckInterval())).deregisterCriticalServiceAfter(String.format("%ss", this.configuration.getDeregisterAfter())).build());
            }
            if (Objects.equals("grpc", uri.getScheme())) {
                return Optional.of(ImmutableRegCheck.builder().grpc(uri.getHost()).interval(String.format("%ss", this.configuration.getCheckInterval())).deregisterCriticalServiceAfter(String.format("%ss", this.configuration.getDeregisterAfter())).build());
            }
            return Optional.empty();
        }).orElseGet(() -> ImmutableRegCheck.builder().ttl(String.format("%ss", this.configuration.getCheckInterval())).deregisterCriticalServiceAfter(String.format("%ss", this.configuration.getDeregisterAfter())).build());
    }
}

