/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import com.orbitz.consul.Consul;
import com.orbitz.consul.option.ConsistencyMode;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;

@UriParams
public abstract class ConsulClientConfiguration
implements Cloneable {
    @UriParam
    private String url;
    @UriParam(label="advanced")
    private String datacenter;
    @UriParam(label="advanced")
    private String nearNode;
    @UriParam(label="advanced")
    private List<String> nodeMeta;
    @UriParam(label="advanced", defaultValue="DEFAULT", enums="DEFAULT,STALE,CONSISTENT")
    private ConsistencyMode consistencyMode = ConsistencyMode.DEFAULT;
    @UriParam(javaType="java.lang.String")
    private Set<String> tags;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="security", secret=true)
    private String aclToken;
    @UriParam(label="security", secret=true)
    private String userName;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam
    private Duration connectTimeout;
    @UriParam
    private Duration readTimeout;
    @UriParam
    private Duration writeTimeout;
    @UriParam(defaultValue="true")
    private boolean pingInstance = true;
    @UriParam(label="consumer,watch", defaultValue="10")
    private Integer blockSeconds = 10;
    @UriParam(label="consumer,watch", defaultValue="0")
    private BigInteger firstIndex = BigInteger.valueOf(0L);
    @UriParam(label="consumer,watch", defaultValue="false")
    private boolean recursive;

    protected ConsulClientConfiguration() {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Deprecated
    public String getDc() {
        return this.datacenter;
    }

    @Deprecated
    public void setDc(String dc) {
        this.datacenter = dc;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public void setDatacenter(String datacenter) {
        this.datacenter = datacenter;
    }

    public String getNearNode() {
        return this.nearNode;
    }

    public void setNearNode(String nearNode) {
        this.nearNode = nearNode;
    }

    public List<String> getNodeMeta() {
        return this.nodeMeta;
    }

    public void setNodeMeta(List<String> nodeMeta) {
        this.nodeMeta = nodeMeta;
    }

    public ConsistencyMode getConsistencyMode() {
        return this.consistencyMode;
    }

    public void setConsistencyMode(ConsistencyMode consistencyMode) {
        this.consistencyMode = consistencyMode;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void setTags(String tagsAsString) {
        this.tags = new HashSet<String>();
        Collections.addAll(this.tags, tagsAsString.split(","));
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public String getAclToken() {
        return this.aclToken;
    }

    public void setAclToken(String aclToken) {
        this.aclToken = aclToken;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean requiresBasicAuthentication() {
        return ObjectHelper.isNotEmpty((String)this.userName) && ObjectHelper.isNotEmpty((String)this.password);
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public boolean isPingInstance() {
        return this.pingInstance;
    }

    public void setPingInstance(boolean pingInstance) {
        this.pingInstance = pingInstance;
    }

    public Integer getBlockSeconds() {
        return this.blockSeconds;
    }

    public void setBlockSeconds(Integer blockSeconds) {
        this.blockSeconds = blockSeconds;
    }

    public BigInteger getFirstIndex() {
        return this.firstIndex;
    }

    public void setFirstIndex(BigInteger firstIndex) {
        this.firstIndex = firstIndex;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public Consul createConsulClient() throws Exception {
        return this.createConsulClient(null);
    }

    public Consul createConsulClient(CamelContext camelContext) throws GeneralSecurityException, IOException {
        Consul.Builder builder = Consul.builder();
        builder.withPing(this.pingInstance);
        if (ObjectHelper.isNotEmpty((String)this.url)) {
            builder.withUrl(this.url);
        }
        if (ObjectHelper.isNotEmpty((Object)camelContext) && ObjectHelper.isNotEmpty((Object)this.sslContextParameters)) {
            builder.withSslContext(this.sslContextParameters.createSSLContext(camelContext));
        }
        if (ObjectHelper.isNotEmpty((String)this.aclToken)) {
            builder.withAclToken(this.aclToken);
        }
        if (this.requiresBasicAuthentication()) {
            builder.withBasicAuth(this.userName, this.password);
        }
        if (ObjectHelper.isNotEmpty((Object)this.connectTimeout)) {
            builder.withConnectTimeoutMillis(this.connectTimeout.toMillis());
        }
        if (ObjectHelper.isNotEmpty((Object)this.readTimeout)) {
            builder.withConnectTimeoutMillis(this.readTimeout.toMillis());
        }
        if (ObjectHelper.isNotEmpty((Object)this.writeTimeout)) {
            builder.withConnectTimeoutMillis(this.writeTimeout.toMillis());
        }
        return builder.build();
    }

    public ConsulClientConfiguration copy() {
        try {
            return (ConsulClientConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

