/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.endpoint;

import com.orbitz.consul.AgentClient;
import com.orbitz.consul.Consul;
import com.orbitz.consul.model.agent.Registration;
import org.apache.camel.Message;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.endpoint.AbstractConsulProducer;
import org.apache.camel.spi.InvokeOnHeader;

public final class ConsulAgentProducer
extends AbstractConsulProducer<AgentClient> {
    public ConsulAgentProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration) {
        super(endpoint, configuration, Consul::agentClient);
    }

    @InvokeOnHeader(value="CHECKS")
    public Object invokeChecks(Message message) throws Exception {
        return ((AgentClient)this.getClient()).getChecks();
    }

    @InvokeOnHeader(value="SERVICES")
    public Object invokeServices(Message message) throws Exception {
        return ((AgentClient)this.getClient()).getServices();
    }

    @InvokeOnHeader(value="MEMBERS")
    public Object invokeMembers(Message message) throws Exception {
        return ((AgentClient)this.getClient()).getMembers();
    }

    @InvokeOnHeader(value="AGENT")
    public Object invokeAgent(Message message) throws Exception {
        return ((AgentClient)this.getClient()).getAgent();
    }

    @InvokeOnHeader(value="REGISTER")
    public void invokeRegister(Message message) throws Exception {
        ((AgentClient)this.getClient()).register((Registration)message.getMandatoryBody(Registration.class));
    }

    @InvokeOnHeader(value="DEREGISTER")
    public void invokeDeregister(Message message) throws Exception {
        ((AgentClient)this.getClient()).deregister(this.getMandatoryHeader(message, "CamelConsulServiceId", String.class), this.buildQueryOptions(message, this.getConfiguration()));
    }
}

