/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.endpoint;

import com.orbitz.consul.Consul;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.model.State;
import org.apache.camel.InvokeOnHeader;
import org.apache.camel.Message;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.endpoint.AbstractConsulProducer;

public final class ConsulHealthProducer
extends AbstractConsulProducer<HealthClient> {
    public ConsulHealthProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration) {
        super(endpoint, configuration, Consul::healthClient);
    }

    @InvokeOnHeader(value="NODE_CHECKS")
    protected void nodeChecks(Message message) throws Exception {
        this.processConsulResponse(message, ((HealthClient)this.getClient()).getNodeChecks(this.getMandatoryHeader(message, "CamelConsulNode", String.class), this.buildQueryOptions(message, this.getConfiguration())));
    }

    @InvokeOnHeader(value="SERVICE_CHECKS")
    protected void serviceChecks(Message message) throws Exception {
        this.processConsulResponse(message, ((HealthClient)this.getClient()).getServiceChecks(this.getMandatoryHeader(message, "CamelConsulService", String.class), this.buildQueryOptions(message, this.getConfiguration())));
    }

    @InvokeOnHeader(value="SERVICE_INSTANCES")
    protected void serviceInstances(Message message) throws Exception {
        boolean healthyOnly = (Boolean)message.getHeader("CamelConsulHealthyOnly", (Object)false, Boolean.TYPE);
        if (healthyOnly) {
            this.processConsulResponse(message, ((HealthClient)this.getClient()).getHealthyServiceInstances(this.getMandatoryHeader(message, "CamelConsulService", String.class), this.buildQueryOptions(message, this.getConfiguration())));
        } else {
            this.processConsulResponse(message, ((HealthClient)this.getClient()).getAllServiceInstances(this.getMandatoryHeader(message, "CamelConsulService", String.class), this.buildQueryOptions(message, this.getConfiguration())));
        }
    }

    @InvokeOnHeader(value="CHECKS")
    protected void checks(Message message) throws Exception {
        this.processConsulResponse(message, ((HealthClient)this.getClient()).getChecksByState(this.getMandatoryHeader(message, "CamelConsulHealthyState", State.class), this.buildQueryOptions(message, this.getConfiguration())));
    }
}

