/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.springboot.health;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.component.consul.health.ConsulHealthCheckRepository;
import org.apache.camel.component.consul.springboot.health.HealthCheckRepositoryConfiguration;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.health.AbstractHealthCheckConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

@Configuration
@AutoConfigureBefore(value={CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="camel.component.consul.health.check.repository", value={"enabled"})
@EnableConfigurationProperties(value={HealthCheckRepositoryConfiguration.class})
public class HealthCheckRepositoryAutoConfiguration {
    @Autowired
    private HealthCheckRepositoryConfiguration configuration;

    @Lazy
    @Bean
    @Scope(value="singleton")
    @ConditionalOnMissingBean(value={ConsulHealthCheckRepository.class})
    public HealthCheckRepository consulRepository() throws Exception {
        return new ConsulHealthCheckRepository.Builder().configuration(this.configuration.asHealthCheckConfiguration()).checks(this.configuration.getChecks()).configurations(this.configuration.getConfigurations() != null ? this.configuration.getConfigurations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AbstractHealthCheckConfiguration)e.getValue()).asHealthCheckConfiguration())) : Collections.emptyMap()).build();
    }
}

