/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="context", displayName="CamelContext", description="Overall information about the CamelContext")
public class ContextDevConsole
extends AbstractDevConsole {
    public ContextDevConsole() {
        super("camel", "context", "CamelContext", "Overall information about the CamelContext");
    }

    protected String doCallText(Map<String, Object> options) {
        ManagedCamelContextMBean mb;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Apache Camel %s %s (%s) uptime %s", this.getCamelContext().getVersion(), this.getCamelContext().getStatus().name().toLowerCase(Locale.ROOT), this.getCamelContext().getName(), CamelContextHelper.getUptime((CamelContext)this.getCamelContext())));
        if (this.getCamelContext().getCamelContextExtension().getProfile() != null) {
            sb.append(String.format("\n    Profile: %s", this.getCamelContext().getCamelContextExtension().getProfile()));
        }
        if (this.getCamelContext().getDescription() != null) {
            sb.append(String.format("\n    %s", this.getCamelContext().getDescription()));
        }
        sb.append("\n");
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null && (mb = mcc.getManagedCamelContext()) != null) {
            String ago;
            Date last;
            String thp;
            int reloaded = 0;
            Set rs = this.getCamelContext().hasServices(ReloadStrategy.class);
            for (ReloadStrategy r : rs) {
                reloaded += r.getReloadCounter();
            }
            String load1 = this.getLoad1(mb);
            String load5 = this.getLoad5(mb);
            String load15 = this.getLoad15(mb);
            if (!(load1.isEmpty() && load5.isEmpty() && load15.isEmpty())) {
                sb.append(String.format("\n    Load Average: %s %s %s", load1, load5, load15));
            }
            if (!(thp = this.getThroughput(mb)).isEmpty()) {
                sb.append(String.format("\n    Messages/Sec: %s", thp));
            }
            sb.append(String.format("\n    Total: %s", mb.getExchangesTotal()));
            sb.append(String.format("\n    Failed: %s", mb.getExchangesFailed()));
            sb.append(String.format("\n    Inflight: %s", mb.getExchangesInflight()));
            long idle = mb.getIdleSince();
            if (idle > 0L) {
                sb.append(String.format("\n    Idle Since: %s", TimeUtils.printDuration((long)idle)));
            } else {
                sb.append(String.format("\n    Idle Since: %s", ""));
            }
            sb.append(String.format("\n    Reloaded: %s", reloaded));
            sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration((long)mb.getMeanProcessingTime(), (boolean)true)));
            sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration((long)mb.getMaxProcessingTime(), (boolean)true)));
            sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration((long)mb.getMinProcessingTime(), (boolean)true)));
            if (mb.getExchangesTotal() > 0L) {
                sb.append(String.format("\n    Last Time: %s", TimeUtils.printDuration((long)mb.getLastProcessingTime(), (boolean)true)));
                sb.append(String.format("\n    Delta Time: %s", TimeUtils.printDuration((long)mb.getDeltaProcessingTime(), (boolean)true)));
            }
            if ((last = mb.getLastExchangeCreatedTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n    Since Last Started: %s", ago));
            }
            if ((last = mb.getLastExchangeCompletedTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n    Since Last Completed: %s", ago));
            }
            if ((last = mb.getLastExchangeFailureTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n    Since Last Failed: %s", ago));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        ManagedCamelContextMBean mb;
        JsonObject root = new JsonObject();
        root.put((Object)"name", (Object)this.getCamelContext().getName());
        if (this.getCamelContext().getDescription() != null) {
            root.put((Object)"description", (Object)this.getCamelContext().getDescription());
        }
        if (this.getCamelContext().getCamelContextExtension().getProfile() != null) {
            root.put((Object)"profile", (Object)this.getCamelContext().getCamelContextExtension().getProfile());
        }
        root.put((Object)"version", (Object)this.getCamelContext().getVersion());
        root.put((Object)"state", (Object)this.getCamelContext().getStatus().name());
        root.put((Object)"phase", (Object)this.getCamelContext().getCamelContextExtension().getStatusPhase());
        root.put((Object)"uptime", (Object)this.getCamelContext().getUptime().toMillis());
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null && (mb = mcc.getManagedCamelContext()) != null) {
            Date last;
            String thp;
            JsonObject stats = new JsonObject();
            int reloaded = 0;
            Set rs = this.getCamelContext().hasServices(ReloadStrategy.class);
            for (ReloadStrategy r : rs) {
                reloaded += r.getReloadCounter();
            }
            String load1 = this.getLoad1(mb);
            String load5 = this.getLoad5(mb);
            String load15 = this.getLoad15(mb);
            if (!(load1.isEmpty() && load5.isEmpty() && load15.isEmpty())) {
                stats.put((Object)"load01", (Object)load1);
                stats.put((Object)"load05", (Object)load5);
                stats.put((Object)"load15", (Object)load15);
            }
            if (!(thp = this.getThroughput(mb)).isEmpty()) {
                stats.put((Object)"exchangesThroughput", (Object)thp);
            }
            stats.put((Object)"idleSince", (Object)mb.getIdleSince());
            stats.put((Object)"exchangesTotal", (Object)mb.getExchangesTotal());
            stats.put((Object)"exchangesFailed", (Object)mb.getExchangesFailed());
            stats.put((Object)"exchangesInflight", (Object)mb.getExchangesInflight());
            stats.put((Object)"reloaded", (Object)reloaded);
            stats.put((Object)"meanProcessingTime", (Object)mb.getMeanProcessingTime());
            stats.put((Object)"maxProcessingTime", (Object)mb.getMaxProcessingTime());
            stats.put((Object)"minProcessingTime", (Object)mb.getMinProcessingTime());
            if (mb.getExchangesTotal() > 0L) {
                stats.put((Object)"lastProcessingTime", (Object)mb.getLastProcessingTime());
                stats.put((Object)"deltaProcessingTime", (Object)mb.getDeltaProcessingTime());
            }
            if ((last = mb.getLastExchangeCreatedTimestamp()) != null) {
                stats.put((Object)"lastCreatedExchangeTimestamp", (Object)last.getTime());
            }
            if ((last = mb.getLastExchangeCompletedTimestamp()) != null) {
                stats.put((Object)"lastCompletedExchangeTimestamp", (Object)last.getTime());
            }
            if ((last = mb.getLastExchangeFailureTimestamp()) != null) {
                stats.put((Object)"lastFailedExchangeTimestamp", (Object)last.getTime());
            }
            root.put((Object)"statistics", (Object)stats);
        }
        return root;
    }

    private String getLoad1(ManagedCamelContextMBean mb) {
        String s = mb.getLoad01();
        s = s.replace(',', '.');
        return s;
    }

    private String getLoad5(ManagedCamelContextMBean mb) {
        String s = mb.getLoad05();
        s = s.replace(',', '.');
        return s;
    }

    private String getLoad15(ManagedCamelContextMBean mb) {
        String s = mb.getLoad15();
        s = s.replace(',', '.');
        return s;
    }

    private String getThroughput(ManagedCamelContextMBean mb) {
        String s = mb.getThroughput();
        s = s.replace(',', '.');
        return s;
    }
}

