/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="bean", description="Displays Java beans from the registry")
public class BeanDevConsole
extends AbstractDevConsole {
    public BeanDevConsole() {
        super("camel", "bean", "Bean", "Displays Java beans from the registry");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        Map beans = this.getCamelContext().getRegistry().findByTypeWithName(Object.class);
        Stream keys = beans.keySet().stream().sorted(String::compareToIgnoreCase);
        keys.forEach(k -> {
            String v = beans.getOrDefault(k, "<null>").getClass().getName();
            sb.append(String.format("    %s (class: %s)%n", k, v));
        });
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        JsonObject jo = new JsonObject();
        root.put((Object)"beans", (Object)jo);
        Map beans = this.getCamelContext().getRegistry().findByTypeWithName(Object.class);
        Stream keys = beans.keySet().stream().sorted(String::compareToIgnoreCase);
        keys.forEach(k -> {
            String v = beans.getOrDefault(k, "null").getClass().getName();
            beans.put(k, v);
        });
        return root;
    }
}

