/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.Closeable;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.Route;
import org.apache.camel.impl.console.ConsoleHelper;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@DevConsole(name="debug", description="Camel route debugger")
public class DebugDevConsole
extends AbstractDevConsole {
    public static final String COMMAND = "command";
    public static final String BREAKPOINT = "breakpoint";
    public static final String CODE_LIMIT = "codeLimit";
    public static final String HISTORY = "history";

    public DebugDevConsole() {
        super("camel", "debug", "Debug", "Camel route debugger");
    }

    protected String doCallText(Map<String, Object> options) {
        String command = (String)options.get(COMMAND);
        String breakpoint = (String)options.get(BREAKPOINT);
        if (ObjectHelper.isNotEmpty((String)command)) {
            this.doCommand(command, breakpoint);
            return "";
        }
        StringBuilder sb = new StringBuilder();
        BacklogDebugger backlog = (BacklogDebugger)this.getCamelContext().hasService(BacklogDebugger.class);
        if (backlog != null) {
            sb.append("Settings:");
            sb.append(String.format("\n    Enabled: %s", backlog.isEnabled()));
            sb.append(String.format("\n    Standby: %s", backlog.isStandby()));
            sb.append(String.format("\n    Suspended Mode: %s", backlog.isSuspendMode()));
            sb.append(String.format("\n    Fallback Timeout: %ss", backlog.getFallbackTimeout()));
            sb.append(String.format("\n    Logging Level: %s", backlog.getLoggingLevel()));
            sb.append(String.format("\n    Include Exchange Properties: %s", backlog.isIncludeExchangeProperties()));
            sb.append(String.format("\n    Include Files: %s", backlog.isBodyIncludeFiles()));
            sb.append(String.format("\n    Include Streams: %s", backlog.isBodyIncludeStreams()));
            sb.append(String.format("\n    Max Chars: %s", backlog.getBodyMaxChars()));
            sb.append("\n\nBreakpoints:");
            sb.append(String.format("\n    Debug Counter: %s", backlog.getDebugCounter()));
            sb.append(String.format("\n    Single Step Mode: %s", backlog.isSingleStepMode()));
            for (String n : backlog.getBreakpoints()) {
                boolean suspended = backlog.getSuspendedBreakpointNodeIds().contains(n);
                if (suspended) {
                    sb.append(String.format("\n    Breakpoint: %s (suspended)", n));
                    continue;
                }
                sb.append(String.format("\n    Breakpoint: %s", n));
            }
            sb.append("\n\nSuspended:");
            for (String n : backlog.getSuspendedBreakpointNodeIds()) {
                sb.append(String.format("\n    Node: %s (suspended)", n));
                BacklogTracerEventMessage trace = backlog.getSuspendedBreakpointMessage(n);
                if (trace == null) continue;
                sb.append("\n");
                sb.append(trace.toXml(8));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private void doCommand(String command, String breakpoint) {
        BacklogDebugger backlog = (BacklogDebugger)this.getCamelContext().hasService(BacklogDebugger.class);
        if (backlog == null) {
            return;
        }
        if ("enable".equalsIgnoreCase(command)) {
            backlog.enableDebugger();
        } else if ("disable".equalsIgnoreCase(command)) {
            backlog.disableDebugger();
        } else if ("attach".equalsIgnoreCase(command)) {
            backlog.attach();
        } else if ("detach".equalsIgnoreCase(command)) {
            backlog.detach();
        } else if ("resume".equalsIgnoreCase(command)) {
            backlog.resumeAll();
        } else if ("step".equalsIgnoreCase(command)) {
            if (ObjectHelper.isNotEmpty((String)breakpoint)) {
                backlog.stepBreakpoint(breakpoint);
            } else {
                backlog.stepBreakpoint();
            }
        } else if ("add".equalsIgnoreCase(command) && ObjectHelper.isNotEmpty((String)breakpoint)) {
            backlog.addBreakpoint(breakpoint);
        } else if ("remove".equalsIgnoreCase(command)) {
            if (ObjectHelper.isNotEmpty((String)breakpoint)) {
                backlog.removeBreakpoint(breakpoint);
            } else {
                backlog.removeAllBreakpoints();
            }
        }
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        String command = (String)options.get(COMMAND);
        String breakpoint = (String)options.get(BREAKPOINT);
        String codeLimit = (String)options.getOrDefault(CODE_LIMIT, "5");
        boolean history = "true".equals(options.getOrDefault(HISTORY, "true"));
        if (ObjectHelper.isNotEmpty((String)command)) {
            this.doCommand(command, breakpoint);
            return root;
        }
        BacklogDebugger backlog = (BacklogDebugger)this.getCamelContext().hasService(BacklogDebugger.class);
        if (backlog != null) {
            root.put((Object)"enabled", (Object)backlog.isEnabled());
            root.put((Object)"standby", (Object)backlog.isStandby());
            root.put((Object)"suspendedMode", (Object)backlog.isSuspendMode());
            root.put((Object)"fallbackTimeout", (Object)backlog.getFallbackTimeout());
            root.put((Object)"loggingLevel", (Object)backlog.getLoggingLevel());
            root.put((Object)"includeExchangeProperties", (Object)backlog.isIncludeExchangeProperties());
            root.put((Object)"includeFiles", (Object)backlog.isBodyIncludeFiles());
            root.put((Object)"includeStreams", (Object)backlog.isBodyIncludeStreams());
            root.put((Object)"maxChars", (Object)backlog.getBodyMaxChars());
            root.put((Object)"debugCounter", (Object)backlog.getDebugCounter());
            root.put((Object)"singleStepMode", (Object)backlog.isSingleStepMode());
            JsonArray arr = new JsonArray();
            for (String n : backlog.getBreakpoints()) {
                JsonObject jo = new JsonObject();
                jo.put((Object)"nodeId", (Object)n);
                boolean suspended = backlog.getSuspendedBreakpointNodeIds().contains(n);
                jo.put((Object)"suspended", (Object)suspended);
                arr.add((Object)jo);
            }
            if (!arr.isEmpty()) {
                root.put((Object)"breakpoints", (Object)arr);
            }
            arr = new JsonArray();
            for (String n : backlog.getSuspendedBreakpointNodeIds()) {
                List<JsonObject> steps;
                BacklogTracerEventMessage t = backlog.getSuspendedBreakpointMessage(n);
                if (t == null) continue;
                JsonObject to = (JsonObject)t.asJSon();
                arr.add((Object)to);
                int limit = Integer.parseInt(codeLimit);
                if (limit > 0) {
                    List<JsonObject> code;
                    String rid = to.getString("routeId");
                    String loc = to.getString("location");
                    if (rid != null && (code = this.enrichSourceCode(rid, loc, limit)) != null && !code.isEmpty()) {
                        to.put((Object)"code", code);
                    }
                }
                if (!history || (steps = this.enrichHistory(backlog, n)).isEmpty()) continue;
                to.put((Object)HISTORY, steps);
            }
            if (!arr.isEmpty()) {
                root.put((Object)"suspended", (Object)arr);
            }
        }
        return root;
    }

    private List<JsonObject> enrichHistory(BacklogDebugger backlog, String id) {
        ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
        Exchange exchange = backlog.getSuspendedExchange(id);
        if (exchange == null) {
            return arr;
        }
        List list = (List)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
        if (list == null) {
            return arr;
        }
        for (MessageHistory h : list) {
            boolean skip;
            NamedRoute nr;
            JsonObject jo = new JsonObject();
            if (h.getNode() != null && (nr = CamelContextHelper.getRoute((NamedNode)h.getNode())) != null && (skip = nr.isCreatedFromRest() || nr.isCreatedFromTemplate())) continue;
            if (h.getRouteId() != null) {
                jo.put((Object)"routeId", (Object)h.getRouteId());
            }
            jo.put((Object)"elapsed", (Object)h.getElapsed());
            if (h.getNode() != null) {
                String t;
                jo.put((Object)"nodeId", (Object)h.getNode().getId());
                if (h.getNode().getLocation() != null) {
                    String loc = h.getNode().getLocation();
                    if (loc.contains(":")) {
                        loc = StringHelper.after((String)loc, (String)":");
                    }
                    jo.put((Object)"location", (Object)loc);
                }
                if (h.getNode().getLineNumber() != -1) {
                    jo.put((Object)"line", (Object)h.getNode().getLineNumber());
                }
                if ((t = ConsoleHelper.loadSourceLine(this.getCamelContext(), h.getNode().getLocation(), h.getNode().getLineNumber())) != null) {
                    jo.put((Object)"code", (Object)Jsoner.escape((String)t));
                }
            }
            arr.add(jo);
        }
        return arr;
    }

    private List<JsonObject> enrichSourceCode(String routeId, String location, int lines) {
        Route route = this.getCamelContext().getRoute(routeId);
        if (route == null) {
            return null;
        }
        Resource resource = route.getSourceResource();
        if (resource == null) {
            return null;
        }
        ArrayList<JsonObject> code = new ArrayList<JsonObject>();
        location = StringHelper.afterLast((String)location, (String)":");
        int line = 0;
        try {
            if (location != null) {
                line = Integer.parseInt(location);
            }
            LineNumberReader reader = new LineNumberReader(resource.getReader());
            for (int i = 1; i <= line + lines; ++i) {
                String t = reader.readLine();
                if (t == null) continue;
                int low = line - lines + 2;
                int high = line + lines + 1 + 2;
                if (i < low || i > high) continue;
                JsonObject c = new JsonObject();
                c.put((Object)"line", (Object)i);
                if (line == i) {
                    c.put((Object)"match", (Object)true);
                }
                c.put((Object)"code", (Object)Jsoner.escape((String)t));
                code.add(c);
            }
            IOHelper.close((Closeable)reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }
}

