/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="type-converters")
public class TypeConverterConsole
extends AbstractDevConsole {
    public TypeConverterConsole() {
        super("camel", "type-converters", "Type Converters", "Camel Type Converter information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        TypeConverterRegistry reg = this.getCamelContext().getTypeConverterRegistry();
        sb.append(String.format("\n    Converters: %s", reg.size()));
        sb.append(String.format("\n    Exists: %s", reg.getTypeConverterExists().name()));
        sb.append(String.format("\n    Exists LoggingLevel: %s", reg.getTypeConverterExistsLoggingLevel()));
        if (reg.getStatistics().isStatisticsEnabled()) {
            sb.append(String.format("\n    Attempts: %s", reg.getStatistics().getAttemptCounter()));
            sb.append(String.format("\n    Hit: %s", reg.getStatistics().getHitCounter()));
            sb.append(String.format("\n    Miss: %s", reg.getStatistics().getMissCounter()));
            sb.append(String.format("\n    Failed: %s", reg.getStatistics().getFailedCounter()));
            sb.append(String.format("\n    Noop: %s", reg.getStatistics().getNoopCounter()));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        TypeConverterRegistry reg = this.getCamelContext().getTypeConverterRegistry();
        root.put((Object)"size", (Object)reg.size());
        root.put((Object)"exists", (Object)reg.getTypeConverterExists().name());
        root.put((Object)"existsLoggingLevel", (Object)reg.getTypeConverterExistsLoggingLevel().name());
        if (reg.getStatistics().isStatisticsEnabled()) {
            JsonObject props = new JsonObject();
            root.put((Object)"statistics", (Object)props);
            props.put((Object)"attemptCounter", (Object)reg.getStatistics().getAttemptCounter());
            props.put((Object)"hitCounter", (Object)reg.getStatistics().getHitCounter());
            props.put((Object)"missCounter", (Object)reg.getStatistics().getAttemptCounter());
            props.put((Object)"failedCounter", (Object)reg.getStatistics().getFailedCounter());
            props.put((Object)"noopCounter", (Object)reg.getStatistics().getNoopCounter());
        }
        return root;
    }
}

