/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Map;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.UnitUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="memory")
@Configurer(bootstrap=true)
public class MemoryDevConsole
extends AbstractDevConsole {
    public MemoryDevConsole() {
        super("jvm", "memory", "JVM Memory", "Displays JVM memory information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
        if (mb != null) {
            sb.append(String.format("Heap Init: %s\n", UnitUtils.printUnitFromBytesDot((long)mb.getHeapMemoryUsage().getInit())));
            sb.append(String.format("Heap Max: %s\n", UnitUtils.printUnitFromBytesDot((long)mb.getHeapMemoryUsage().getMax())));
            sb.append(String.format("Heap Used: %s\n", UnitUtils.printUnitFromBytesDot((long)mb.getHeapMemoryUsage().getUsed())));
            sb.append(String.format("Heap Committed: %s\n", UnitUtils.printUnitFromBytesDot((long)mb.getHeapMemoryUsage().getCommitted())));
            sb.append("\n");
            sb.append(String.format("Non-Heap Init: %s\n", UnitUtils.printUnitFromBytesDot((long)mb.getNonHeapMemoryUsage().getInit())));
            sb.append(String.format("Non-Heap Max: %s\n", UnitUtils.printUnitFromBytesDot((long)mb.getNonHeapMemoryUsage().getMax())));
            sb.append(String.format("Non-Heap Used: %s\n", UnitUtils.printUnitFromBytesDot((long)mb.getNonHeapMemoryUsage().getUsed())));
            sb.append(String.format("Non-Heap Committed: %s\n", UnitUtils.printUnitFromBytesDot((long)mb.getNonHeapMemoryUsage().getCommitted())));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
        if (mb != null) {
            root.put((Object)"heapMemoryInit", (Object)UnitUtils.printUnitFromBytesDot((long)mb.getHeapMemoryUsage().getInit()));
            root.put((Object)"heapMemoryMax", (Object)UnitUtils.printUnitFromBytesDot((long)mb.getHeapMemoryUsage().getMax()));
            root.put((Object)"heapMemoryUsed", (Object)UnitUtils.printUnitFromBytesDot((long)mb.getHeapMemoryUsage().getUsed()));
            root.put((Object)"heapMemoryCommitted", (Object)UnitUtils.printUnitFromBytesDot((long)mb.getHeapMemoryUsage().getCommitted()));
            root.put((Object)"nonHeapMemoryInit", (Object)UnitUtils.printUnitFromBytesDot((long)mb.getNonHeapMemoryUsage().getInit()));
            root.put((Object)"nonHeapMemoryMax", (Object)UnitUtils.printUnitFromBytesDot((long)mb.getNonHeapMemoryUsage().getMax()));
            root.put((Object)"nonHeapMemoryUsed", (Object)UnitUtils.printUnitFromBytesDot((long)mb.getNonHeapMemoryUsage().getUsed()));
            root.put((Object)"nonHeapMemoryCommitted", (Object)UnitUtils.printUnitFromBytesDot((long)mb.getNonHeapMemoryUsage().getCommitted()));
        }
        return root;
    }
}

