/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="reload")
public class ReloadDevConsole
extends AbstractDevConsole {
    public static final String RELOAD = "reload";
    private volatile ExecutorService reloadThread;

    public ReloadDevConsole() {
        super("camel", RELOAD, "Reload", "Console for reloading running Camel");
    }

    protected String doCallText(Map<String, Object> options) {
        String trigger = (String)options.get(RELOAD);
        StringBuilder sb = new StringBuilder();
        Set rs = this.getCamelContext().hasServices(ReloadStrategy.class);
        for (ReloadStrategy r : rs) {
            if ("true".equals(trigger)) {
                this.getOrCreateReloadTask().submit(() -> r.onReload((Object)"ReloadDevConsole"));
                continue;
            }
            sb.append(String.format("\nReloadStrategy: %s", r.getClass().getName()));
            sb.append(String.format("\n    Reloaded: %s", r.getReloadCounter()));
            sb.append(String.format("\n    Failed: %s", r.getFailedCounter()));
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String trigger = (String)options.get(RELOAD);
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        Set rs = this.getCamelContext().hasServices(ReloadStrategy.class);
        for (ReloadStrategy r : rs) {
            if ("true".equals(trigger)) {
                this.getOrCreateReloadTask().submit(() -> r.onReload((Object)"ReloadDevConsole"));
                continue;
            }
            if (root.isEmpty()) {
                root.put((Object)"reloadStrategies", (Object)arr);
            }
            JsonObject jo = new JsonObject();
            arr.add((Object)jo);
            jo.put((Object)"className", (Object)r.getClass().getName());
            jo.put((Object)"reloaded", (Object)r.getReloadCounter());
            jo.put((Object)"failed", (Object)r.getFailedCounter());
        }
        return root;
    }

    protected ExecutorService getOrCreateReloadTask() {
        if (this.reloadThread == null) {
            this.reloadThread = this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "ReloadOnDemand");
        }
        return this.reloadThread;
    }

    protected void doStop() throws Exception {
        if (this.reloadThread != null) {
            this.getCamelContext().getExecutorServiceManager().shutdown(this.reloadThread);
            this.reloadThread = null;
        }
    }
}

