/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.connector;

public final class DataType {
    private final Type type;
    private final String subType;

    DataType(String text) {
        String[] parts = text.split(":");
        String name = parts[0].toLowerCase();
        if ("*".equals(name)) {
            name = "any";
        }
        this.type = Type.valueOf(name);
        this.subType = parts.length == 2 ? parts[1] : null;
    }

    DataType(Type type, String subType) {
        this.type = type;
        this.subType = subType;
    }

    public Type getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public String toString() {
        if (this.subType != null) {
            return this.type.name() + ":" + this.subType;
        }
        return this.type.name();
    }

    public static enum Type {
        none,
        any,
        java,
        text,
        xml,
        json;

    }
}

