/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Component;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Configuration;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;

public interface Aws2RedshiftDataComponentBuilderFactory {
    public static Aws2RedshiftDataComponentBuilder aws2RedshiftData() {
        return new Aws2RedshiftDataComponentBuilderImpl();
    }

    public static class Aws2RedshiftDataComponentBuilderImpl
    extends AbstractComponentBuilder<RedshiftData2Component>
    implements Aws2RedshiftDataComponentBuilder {
        @Override
        protected RedshiftData2Component buildConcreteComponent() {
            return new RedshiftData2Component();
        }

        private RedshiftData2Configuration getOrCreateConfiguration(RedshiftData2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new RedshiftData2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((RedshiftData2Component)component).setConfiguration((RedshiftData2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((RedshiftData2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setOperation((RedshiftData2Operations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setRegion((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((RedshiftData2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "awsRedshiftDataClient": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setAwsRedshiftDataClient((RedshiftDataClient)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((RedshiftData2Component)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((RedshiftData2Component)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "sessionToken": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setSessionToken((String)value);
                    return true;
                }
                case "useSessionCredentials": {
                    this.getOrCreateConfiguration((RedshiftData2Component)component).setUseSessionCredentials(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2RedshiftDataComponentBuilder
    extends ComponentBuilder<RedshiftData2Component> {
        default public Aws2RedshiftDataComponentBuilder configuration(RedshiftData2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder operation(RedshiftData2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder awsRedshiftDataClient(RedshiftDataClient awsRedshiftDataClient) {
            this.doSetProperty("awsRedshiftDataClient", awsRedshiftDataClient);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public Aws2RedshiftDataComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

