/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.stitch.StitchComponent;
import org.apache.camel.component.stitch.StitchConfiguration;
import org.apache.camel.component.stitch.client.StitchClient;
import org.apache.camel.component.stitch.client.StitchRegion;
import org.apache.camel.component.stitch.client.models.StitchSchema;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public interface StitchComponentBuilderFactory {
    public static StitchComponentBuilder stitch() {
        return new StitchComponentBuilderImpl();
    }

    public static class StitchComponentBuilderImpl
    extends AbstractComponentBuilder<StitchComponent>
    implements StitchComponentBuilder {
        @Override
        protected StitchComponent buildConcreteComponent() {
            return new StitchComponent();
        }

        private StitchConfiguration getOrCreateConfiguration(StitchComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new StitchConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((StitchComponent)component).setConfiguration((StitchConfiguration)value);
                    return true;
                }
                case "keyNames": {
                    this.getOrCreateConfiguration((StitchComponent)component).setKeyNames((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((StitchComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((StitchComponent)component).setRegion((StitchRegion)value);
                    return true;
                }
                case "stitchSchema": {
                    this.getOrCreateConfiguration((StitchComponent)component).setStitchSchema((StitchSchema)value);
                    return true;
                }
                case "connectionProvider": {
                    this.getOrCreateConfiguration((StitchComponent)component).setConnectionProvider((ConnectionProvider)value);
                    return true;
                }
                case "httpClient": {
                    this.getOrCreateConfiguration((StitchComponent)component).setHttpClient((HttpClient)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((StitchComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "stitchClient": {
                    this.getOrCreateConfiguration((StitchComponent)component).setStitchClient((StitchClient)value);
                    return true;
                }
                case "token": {
                    this.getOrCreateConfiguration((StitchComponent)component).setToken((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface StitchComponentBuilder
    extends ComponentBuilder<StitchComponent> {
        default public StitchComponentBuilder configuration(StitchConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public StitchComponentBuilder keyNames(String keyNames) {
            this.doSetProperty("keyNames", keyNames);
            return this;
        }

        default public StitchComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public StitchComponentBuilder region(StitchRegion region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public StitchComponentBuilder stitchSchema(StitchSchema stitchSchema) {
            this.doSetProperty("stitchSchema", stitchSchema);
            return this;
        }

        default public StitchComponentBuilder connectionProvider(ConnectionProvider connectionProvider) {
            this.doSetProperty("connectionProvider", connectionProvider);
            return this;
        }

        default public StitchComponentBuilder httpClient(HttpClient httpClient) {
            this.doSetProperty("httpClient", httpClient);
            return this;
        }

        default public StitchComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public StitchComponentBuilder stitchClient(StitchClient stitchClient) {
            this.doSetProperty("stitchClient", stitchClient);
            return this;
        }

        default public StitchComponentBuilder token(String token) {
            this.doSetProperty("token", token);
            return this;
        }
    }
}

