/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import dev.langchain4j.model.embedding.EmbeddingModel;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.langchain.embeddings.LangChainEmbeddingsComponent;
import org.apache.camel.component.langchain.embeddings.LangChainEmbeddingsConfiguration;

public interface LangchainEmbeddingsComponentBuilderFactory {
    public static LangchainEmbeddingsComponentBuilder langchainEmbeddings() {
        return new LangchainEmbeddingsComponentBuilderImpl();
    }

    public static class LangchainEmbeddingsComponentBuilderImpl
    extends AbstractComponentBuilder<LangChainEmbeddingsComponent>
    implements LangchainEmbeddingsComponentBuilder {
        @Override
        protected LangChainEmbeddingsComponent buildConcreteComponent() {
            return new LangChainEmbeddingsComponent();
        }

        private LangChainEmbeddingsConfiguration getOrCreateConfiguration(LangChainEmbeddingsComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new LangChainEmbeddingsConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((LangChainEmbeddingsComponent)component).setConfiguration((LangChainEmbeddingsConfiguration)value);
                    return true;
                }
                case "embeddingModel": {
                    this.getOrCreateConfiguration((LangChainEmbeddingsComponent)component).setEmbeddingModel((EmbeddingModel)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((LangChainEmbeddingsComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((LangChainEmbeddingsComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface LangchainEmbeddingsComponentBuilder
    extends ComponentBuilder<LangChainEmbeddingsComponent> {
        default public LangchainEmbeddingsComponentBuilder configuration(LangChainEmbeddingsConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public LangchainEmbeddingsComponentBuilder embeddingModel(EmbeddingModel embeddingModel) {
            this.doSetProperty("embeddingModel", embeddingModel);
            return this;
        }

        default public LangchainEmbeddingsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public LangchainEmbeddingsComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

