/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import dev.langchain4j.model.chat.ChatLanguageModel;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.chat.LangChainChatComponent;
import org.apache.camel.component.chat.LangChainChatConfiguration;
import org.apache.camel.component.chat.LangChainChatOperations;

public interface LangchainChatComponentBuilderFactory {
    public static LangchainChatComponentBuilder langchainChat() {
        return new LangchainChatComponentBuilderImpl();
    }

    public static class LangchainChatComponentBuilderImpl
    extends AbstractComponentBuilder<LangChainChatComponent>
    implements LangchainChatComponentBuilder {
        @Override
        protected LangChainChatComponent buildConcreteComponent() {
            return new LangChainChatComponent();
        }

        private LangChainChatConfiguration getOrCreateConfiguration(LangChainChatComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new LangChainChatConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "chatOperation": {
                    this.getOrCreateConfiguration((LangChainChatComponent)component).setChatOperation((LangChainChatOperations)value);
                    return true;
                }
                case "configuration": {
                    ((LangChainChatComponent)component).setConfiguration((LangChainChatConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((LangChainChatComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((LangChainChatComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "chatModel": {
                    this.getOrCreateConfiguration((LangChainChatComponent)component).setChatModel((ChatLanguageModel)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface LangchainChatComponentBuilder
    extends ComponentBuilder<LangChainChatComponent> {
        default public LangchainChatComponentBuilder chatOperation(LangChainChatOperations chatOperation) {
            this.doSetProperty("chatOperation", chatOperation);
            return this;
        }

        default public LangchainChatComponentBuilder configuration(LangChainChatConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public LangchainChatComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public LangchainChatComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public LangchainChatComponentBuilder chatModel(ChatLanguageModel chatModel) {
            this.doSetProperty("chatModel", chatModel);
            return this;
        }
    }
}

