/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.cloudtrail.CloudtrailComponent;
import org.apache.camel.component.aws.cloudtrail.CloudtrailConfiguration;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;

public interface AwsCloudtrailComponentBuilderFactory {
    public static AwsCloudtrailComponentBuilder awsCloudtrail() {
        return new AwsCloudtrailComponentBuilderImpl();
    }

    public static class AwsCloudtrailComponentBuilderImpl
    extends AbstractComponentBuilder<CloudtrailComponent>
    implements AwsCloudtrailComponentBuilder {
        @Override
        protected CloudtrailComponent buildConcreteComponent() {
            return new CloudtrailComponent();
        }

        private CloudtrailConfiguration getOrCreateConfiguration(CloudtrailComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new CloudtrailConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "bridgeErrorHandler": {
                    ((CloudtrailComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((CloudtrailComponent)component).setConfiguration((CloudtrailConfiguration)value);
                    return true;
                }
                case "eventSource": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setEventSource((String)value);
                    return true;
                }
                case "maxResults": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setMaxResults(((Integer)value).intValue());
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setRegion((String)value);
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((CloudtrailComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "cloudTrailClient": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setCloudTrailClient((CloudTrailClient)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((CloudtrailComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((CloudtrailComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setSecretKey((String)value);
                    return true;
                }
                case "sessionToken": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setSessionToken((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setUseDefaultCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useSessionCredentials": {
                    this.getOrCreateConfiguration((CloudtrailComponent)component).setUseSessionCredentials(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsCloudtrailComponentBuilder
    extends ComponentBuilder<CloudtrailComponent> {
        default public AwsCloudtrailComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AwsCloudtrailComponentBuilder configuration(CloudtrailConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsCloudtrailComponentBuilder eventSource(String eventSource) {
            this.doSetProperty("eventSource", eventSource);
            return this;
        }

        default public AwsCloudtrailComponentBuilder maxResults(int maxResults) {
            this.doSetProperty("maxResults", maxResults);
            return this;
        }

        default public AwsCloudtrailComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public AwsCloudtrailComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsCloudtrailComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public AwsCloudtrailComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AwsCloudtrailComponentBuilder cloudTrailClient(CloudTrailClient cloudTrailClient) {
            this.doSetProperty("cloudTrailClient", cloudTrailClient);
            return this;
        }

        default public AwsCloudtrailComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public AwsCloudtrailComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public AwsCloudtrailComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsCloudtrailComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsCloudtrailComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsCloudtrailComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsCloudtrailComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public AwsCloudtrailComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AwsCloudtrailComponentBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public AwsCloudtrailComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public AwsCloudtrailComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public AwsCloudtrailComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public AwsCloudtrailComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

