/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.cometd.CometdBinding;
import org.apache.camel.component.cometd.CometdEndpoint;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.ExchangeHelper;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractService;
import org.cometd.server.BayeuxServerImpl;

public class CometdConsumer
extends DefaultConsumer
implements CometdProducerConsumer {
    private BayeuxServerImpl bayeux;
    private final CometdEndpoint endpoint;
    private ConsumerService service;

    public CometdConsumer(CometdEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.endpoint.connect(this);
        if (this.service == null) {
            this.service = new ConsumerService(this.endpoint.getPath(), this.bayeux, this);
        }
    }

    public void doStop() throws Exception {
        this.endpoint.disconnect(this);
        super.doStop();
    }

    @Override
    public void setBayeux(BayeuxServerImpl bayeux) {
        this.bayeux = bayeux;
    }

    @Override
    public CometdEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ConsumerService getConsumerService() {
        return this.service;
    }

    public static class ConsumerService
    extends AbstractService {
        private final CometdEndpoint endpoint;
        private final CometdConsumer consumer;
        private final CometdBinding binding;
        private final String channelName;

        public ConsumerService(String channel, BayeuxServerImpl bayeux, CometdConsumer consumer) {
            super((BayeuxServer)bayeux, channel);
            this.endpoint = consumer.getEndpoint();
            this.binding = this.createBinding(bayeux);
            this.consumer = consumer;
            this.channelName = channel;
            this.addService(channel, "push");
        }

        private CometdBinding createBinding(BayeuxServerImpl bayeux) {
            boolean enableSessionHeaders = this.endpoint != null && this.endpoint.isSessionHeadersEnabled();
            return new CometdBinding(bayeux, enableSessionHeaders);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(ServerSession remote, ServerMessage cometdMessage) throws Exception {
            Object data = null;
            Message message = this.binding.createCamelMessage(this.endpoint.getCamelContext(), remote, cometdMessage, data);
            Exchange exchange = this.consumer.createExchange(false);
            try {
                exchange.setIn(message);
                this.consumer.getProcessor().process(exchange);
                if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                    ServerChannel channel = this.getBayeux().getChannel(this.channelName);
                    ServerSession serverSession = this.getServerSession();
                    ServerMessage.Mutable outMessage = this.binding.createCometdMessage(channel, serverSession, exchange.getOut());
                    remote.deliver((Session)serverSession, outMessage, Promise.noop());
                }
            }
            finally {
                this.consumer.releaseExchange(exchange, false);
            }
        }
    }
}

