/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CometdEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/channelName";
    private static final String[] SCHEMES = new String[]{"cometd", "cometds"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "channelName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(19);
        props.add("exchangePattern");
        props.add("jsonCommented");
        props.add("maxInterval");
        props.add("timeout");
        props.add("filterPath");
        props.add("lazyStartProducer");
        props.add("baseResource");
        props.add("bridgeErrorHandler");
        props.add("disconnectLocalSession");
        props.add("allowedOrigins");
        props.add("crossOriginFilterOn");
        props.add("logLevel");
        props.add("port");
        props.add("host");
        props.add("channelName");
        props.add("interval");
        props.add("multiFrameInterval");
        props.add("exceptionHandler");
        props.add("sessionHeadersEnabled");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

