/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.util.LinkedList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.coap.CamelCoapResource;
import org.apache.camel.coap.CoAPEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.server.resources.Resource;

public class CoAPConsumer
extends DefaultConsumer {
    private final CoAPEndpoint endpoint;
    private List<CoapResource> resources = new LinkedList<CoapResource>();

    public CoAPConsumer(CoAPEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public CoAPEndpoint getCoapEndpoint() {
        return this.endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        String path = this.endpoint.getUri().getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Resource cr = this.endpoint.getCoapServer().getRoot();
        while (!path.isEmpty()) {
            int idx = path.indexOf(47);
            String part1 = path;
            if (idx != -1) {
                part1 = path.substring(0, idx);
                path = path.substring(idx + 1);
            } else {
                path = "";
            }
            Object child = cr.getChild(part1);
            if (child == null) {
                child = new CamelCoapResource(part1, this);
                cr.add(child);
                cr = child;
                continue;
            }
            if (path.isEmpty()) {
                ((CamelCoapResource)((Object)child)).addConsumer(this);
                continue;
            }
            cr = child;
        }
    }

    protected void doStop() throws Exception {
        for (CoapResource r : this.resources) {
            r.getParent().delete((Resource)r);
        }
        this.resources.clear();
        super.doStop();
    }
}

