/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cm.validation.constraints;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.camel.component.cm.validation.constraints.E164;

public class E164Validator
implements ConstraintValidator<E164, String> {
    private final PhoneNumberUtil pnu = PhoneNumberUtil.getInstance();

    public void initialize(E164 constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        try {
            Phonenumber.PhoneNumber parsingResult = this.pnu.parse((CharSequence)value, null);
            return this.pnu.format(parsingResult, PhoneNumberUtil.PhoneNumberFormat.E164).equals(value);
        }
        catch (NumberParseException t) {
            return false;
        }
    }
}

