/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cloudevents;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public interface CloudEvent {
    public static final String CAMEL_CLOUD_EVENT_ID = "CamelCloudEventID";
    public static final String CAMEL_CLOUD_EVENT_SOURCE = "CamelCloudEventSource";
    public static final String CAMEL_CLOUD_EVENT_VERSION = "CamelCloudEventVersion";
    public static final String CAMEL_CLOUD_EVENT_TYPE = "CamelCloudEventType";
    public static final String CAMEL_CLOUD_EVENT_TYPE_VERSION = "CamelCloudEventTypeVersion";
    public static final String CAMEL_CLOUD_EVENT_DATA_CONTENT_TYPE = "CamelCloudEventDataContentType";
    public static final String CAMEL_CLOUD_EVENT_DATA_CONTENT_ENCODING = "CamelCloudEventDataContentEncoding";
    public static final String CAMEL_CLOUD_EVENT_SCHEMA_URL = "CamelCloudEventSchemaURL";
    public static final String CAMEL_CLOUD_EVENT_SUBJECT = "CamelCloudEventSubject";
    public static final String CAMEL_CLOUD_EVENT_TIME = "CamelCloudEventTime";
    public static final String CAMEL_CLOUD_EVENT_EXTENSIONS = "CamelCloudEventExtensions";
    public static final String CAMEL_CLOUD_EVENT_CONTENT_TYPE = "Content-Type";

    public String version();

    public Collection<Attribute> attributes();

    default public Optional<Attribute> attribute(String id) {
        return this.attributes().stream().filter(a -> Objects.equals(id, a.id())).findFirst();
    }

    default public Attribute mandatoryAttribute(String id) {
        return this.attributes().stream().filter(a -> Objects.equals(id, a.id())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find attribute with id: " + id));
    }

    default public String httpAttribute(String id) {
        return this.mandatoryAttribute(id).http();
    }

    default public String jsonAttribute(String id) {
        return this.mandatoryAttribute(id).json();
    }

    public static interface Attribute {
        public String id();

        public String http();

        public String json();

        public static Attribute simple(final String id, final String http, final String json) {
            return new Attribute(){

                @Override
                public String id() {
                    return id;
                }

                @Override
                public String http() {
                    return http;
                }

                @Override
                public String json() {
                    return json;
                }
            };
        }
    }
}

