/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.clickup.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.Message;
import org.apache.camel.component.clickup.InvalidMessageSignatureException;
import org.apache.camel.component.clickup.model.Webhook;
import org.apache.camel.component.clickup.model.WebhookCreationCommand;
import org.apache.camel.component.clickup.model.errors.WebhookAlreadyExistsException;
import org.apache.camel.component.clickup.service.ClickUpService;
import org.apache.camel.component.clickup.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickUpWebhookService {
    private static final Logger LOG = LoggerFactory.getLogger(ClickUpWebhookService.class);
    private final ClickUpService clickUpService;

    public ClickUpWebhookService(ClickUpService clickUpService) {
        this.clickUpService = clickUpService;
    }

    public Webhook registerWebhook(Long workspaceId, String endpointUrl, Set<String> events) {
        try {
            WebhookCreationCommand command = new WebhookCreationCommand();
            command.setEndpoint(endpointUrl);
            command.setEvents(events);
            return this.clickUpService.createWebhook(workspaceId, command);
        }
        catch (WebhookAlreadyExistsException e) {
            LOG.info("Another webhook with the same configuration already exists, trying to reuse it...");
            Set<Webhook> webhooks = this.clickUpService.getWebhooks(workspaceId);
            Optional<Webhook> matchingWebhook = webhooks.stream().filter(webhook -> webhook.matchesConfiguration(endpointUrl, events)).findFirst();
            if (matchingWebhook.isEmpty()) {
                throw new RuntimeException("Cannot find the matching webhook.", e);
            }
            LOG.info("Found webhook {} with the same configuration, reusing it", (Object)matchingWebhook.get().getId());
            return matchingWebhook.get();
        }
    }

    public void validateMessageSignature(Message message, String sharedSecret) {
        String messageBody;
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        if (sharedSecret == null) {
            throw new IllegalArgumentException("sharedSecret cannot be null");
        }
        String signature = (String)message.getHeader("x-signature");
        if (signature == null) {
            throw new RuntimeException("The webhook HTTP request doesn't contain the 'x-signature' header.");
        }
        try (InputStream body = (InputStream)message.getBody(InputStream.class);){
            messageBody = new String(body.readAllBytes());
            LOG.debug("Message body {} to be validated against the given signature {}", (Object)messageBody, (Object)signature);
            body.reset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String calculatedSignature = Utils.computeMessageHMAC(messageBody, sharedSecret);
        signature = signature.toLowerCase();
        calculatedSignature = calculatedSignature.toLowerCase();
        boolean signatureMatches = calculatedSignature.equals(signature);
        if (!signatureMatches) {
            LOG.debug("The message signature {} does not match {}.", (Object)signature, (Object)calculatedSignature);
            throw new InvalidMessageSignatureException(messageBody, signature, calculatedSignature);
        }
        LOG.debug("The message signature {} matches {}.", (Object)signature, (Object)calculatedSignature);
    }
}

