/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.clickup;

import java.util.Map;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.component.clickup.ClickUpConfiguration;
import org.apache.camel.component.clickup.ClickUpEndpoint;
import org.apache.camel.component.clickup.model.Events;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="clickup")
public class ClickUpComponent
extends DefaultComponent {
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ClickUpConfiguration configuration = new ClickUpConfiguration();
        if (remaining.endsWith("/")) {
            remaining = remaining.substring(0, remaining.length() - 1);
        }
        Long workspaceId = Long.parseLong(remaining);
        configuration.setWorkspaceId(workspaceId);
        ClickUpEndpoint endpoint = new ClickUpEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (ObjectHelper.isEmpty((String)endpoint.getConfiguration().getAuthorizationToken())) {
            throw new IllegalArgumentException("AuthorizationToken must be configured for clickup: " + uri);
        }
        if (!Events.areAllEventsSupported(endpoint.getConfiguration().getEvents())) {
            Set<String> unsupportedEvents = Events.computeUnsupportedEvents(endpoint.getConfiguration().getEvents());
            throw new IllegalArgumentException("The following events are not yet supported: " + unsupportedEvents);
        }
        return endpoint;
    }
}

