/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.chronicle.engine;

import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.tree.VanillaAssetTree;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.chronicle.engine.ChronicleEngineComponent;
import org.apache.camel.component.chronicle.engine.ChronicleEngineConfiguration;
import org.apache.camel.component.chronicle.engine.ChronicleEngineConsumer;
import org.apache.camel.component.chronicle.engine.ChronicleEngineProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.18.0", scheme="chronicle-engine", title="Chronicle Engine", syntax="chronicle-engine:addresses/path", consumerClass=ChronicleEngineConsumer.class, label="datagrid,cache")
public class ChronicleEngineEndpoint
extends DefaultEndpoint {
    @UriPath(description="Engine addresses. Multiple addresses can be separated by comma.")
    @Metadata(required="true")
    private String addresses;
    @UriPath(description="Engine path")
    @Metadata(required="true")
    private String path;
    @UriParam
    private ChronicleEngineConfiguration configuration;

    public ChronicleEngineEndpoint(String uri, ChronicleEngineComponent component, ChronicleEngineConfiguration configuration) throws Exception {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        return new ChronicleEngineProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new ChronicleEngineConsumer(this, processor);
    }

    protected void doStart() throws Exception {
        if (!this.path.startsWith("/")) {
            this.path = "/" + this.path;
        }
    }

    protected void doStop() throws Exception {
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setConfiguration(ChronicleEngineConfiguration configuration) {
        this.configuration = configuration;
    }

    protected ChronicleEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    protected String getPath() {
        return this.path;
    }

    protected String getUri() {
        return this.configuration.isPersistent() ? this.path : this.path + "?dontPersist=true";
    }

    protected AssetTree createRemoteAssetTree() {
        String[] urls = this.addresses.split(",");
        return new VanillaAssetTree().forRemoteAccess(urls, this.configuration.getWireType());
    }
}

