/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.chatscript;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.apache.camel.component.chatscript.ChatScriptMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatScriptBot {
    private static final transient Logger LOG = LoggerFactory.getLogger(ChatScriptBot.class);
    String host;
    int port;
    String message;
    String botName;
    String userName;
    boolean initialized;

    public ChatScriptBot(String iHost, int port, String iBotName, String iUserName) {
        this.host = iHost;
        this.port = port;
        this.botName = iBotName;
        this.userName = iUserName;
    }

    public String sendChat(String input) throws Exception {
        if (!this.initialized) {
            return this.init(null);
        }
        ChatScriptMessage g = new ChatScriptMessage(this.userName, this.botName, input);
        return this.doMessage(g.toCSFormat());
    }

    public String sendChat(ChatScriptMessage input) throws Exception {
        if (!this.initialized) {
            return this.init(input);
        }
        return this.doMessage(input.toCSFormat());
    }

    private String doMessage(ChatScriptMessage msg) throws Exception {
        return this.doMessage(msg.toCSFormat());
    }

    private String doMessage(String msg) throws Exception {
        String resp = "";
        try (Socket echoSocket = new Socket(this.host, this.port);
             PrintWriter out = new PrintWriter(echoSocket.getOutputStream(), true);
             BufferedReader in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));){
            out.println(msg);
            resp = in.readLine();
        }
        catch (IOException e) {
            throw new Exception("Unable to send message to ChatScript Server. Reason:" + e.getMessage(), e);
        }
        return resp;
    }

    public String init(ChatScriptMessage input) throws Exception {
        ChatScriptMessage g = new ChatScriptMessage(input.getUserName(), this.botName, null);
        String response = this.doMessage(g);
        LOG.info("Conversation started between the bot {} and {}", (Object)this.botName, (Object)input.getUserName());
        this.initialized = true;
        return response;
    }

    public String getBotType() {
        return "ChatSCript";
    }

    public void reset() {
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int iPort) {
        this.port = iPort;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String iMessage) {
        this.message = iMessage;
    }

    public String getBotName() {
        return this.botName;
    }

    public void setBotName(String iBotName) {
        this.botName = iBotName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String iUserName) {
        this.userName = iUserName;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

