/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.cdi.CdiEventConsumer;
import org.apache.camel.cdi.CdiEventProducer;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.support.DefaultEndpoint;

@javax.enterprise.inject.Vetoed
public final class CdiEventEndpoint<T>
extends DefaultEndpoint {
    private final List<CdiEventConsumer<T>> consumers = new ArrayList<CdiEventConsumer<T>>();
    private final Type type;
    private final Set<Annotation> qualifiers;
    private final BeanManager manager;

    CdiEventEndpoint(String endpointUri, Type type, Set<Annotation> qualifiers, BeanManager manager) {
        super(endpointUri, null);
        this.type = type;
        this.qualifiers = qualifiers;
        this.manager = manager;
    }

    static String eventEndpointUri(Type type, Set<Annotation> qualifiers) {
        return "cdi-event://" + CdiEventEndpoint.authorityFromType(type) + qualifiers.stream().map(CdiSpiHelper::createAnnotationId).collect(Collectors.joining("%2C", !qualifiers.isEmpty() ? "?qualifiers=" : "", ""));
    }

    private static String authorityFromType(Type type) {
        if (type instanceof Class) {
            return ((Class)Class.class.cast(type)).getName();
        }
        if (type instanceof ParameterizedType) {
            return Stream.of(((ParameterizedType)type).getActualTypeArguments()).map(CdiEventEndpoint::authorityFromType).collect(Collectors.joining("%2C", CdiEventEndpoint.authorityFromType(((ParameterizedType)type).getRawType()) + "%3C", "%3E"));
        }
        if (type instanceof GenericArrayType) {
            return CdiEventEndpoint.authorityFromType(((GenericArrayType)type).getGenericComponentType()) + "%5B%5D";
        }
        throw new IllegalArgumentException("Cannot create URI authority for event type [" + type + "]");
    }

    Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    Type getType() {
        return this.type;
    }

    public Consumer createConsumer(Processor processor) {
        return new CdiEventConsumer(this, processor);
    }

    public Producer createProducer() throws IllegalAccessException {
        TypeLiteral literal = new TypeLiteral<T>(){};
        for (Field field : TypeLiteral.class.getDeclaredFields()) {
            if (!field.getType().equals(Type.class)) continue;
            field.setAccessible(true);
            field.set(literal, this.type);
            break;
        }
        InjectionTarget target = this.manager.createInjectionTarget(this.manager.createAnnotatedType(AnyEvent.class));
        CreationalContext ctx = this.manager.createCreationalContext(null);
        AnyEvent instance = (AnyEvent)target.produce(ctx);
        target.inject((Object)instance, ctx);
        return new CdiEventProducer(this, instance.event.select(literal, this.qualifiers.toArray(new Annotation[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(CdiEventConsumer<T> consumer) {
        List<CdiEventConsumer<T>> list = this.consumers;
        synchronized (list) {
            this.consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(CdiEventConsumer<T> consumer) {
        List<CdiEventConsumer<T>> list = this.consumers;
        synchronized (list) {
            this.consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(T t) {
        List<CdiEventConsumer<T>> list = this.consumers;
        synchronized (list) {
            this.consumers.forEach(consumer -> consumer.notify(t));
        }
    }

    @Vetoed
    private static class AnyEvent {
        @Any
        @Inject
        private Event<Object> event;

        private AnyEvent() {
        }
    }
}

