/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.camel.cdi.CdiCamelBeanPostProcessor;
import org.apache.camel.cdi.DelegateInjectionTarget;

@Vetoed
final class CamelBeanInjectionTarget<T>
extends DelegateInjectionTarget<T>
implements InjectionTarget<T> {
    private final InjectionTarget<T> delegate;
    private final CdiCamelBeanPostProcessor processor;

    CamelBeanInjectionTarget(InjectionTarget<T> delegate, BeanManager manager) {
        super(delegate);
        this.delegate = delegate;
        this.processor = new CdiCamelBeanPostProcessor(manager);
    }

    @Override
    public void inject(T instance, CreationalContext<T> ctx) {
        super.inject(instance, ctx);
        try {
            this.processor.postProcessBeforeInitialization(instance, instance.getClass().getName());
            this.processor.postProcessAfterInitialization(instance, instance.getClass().getName());
        }
        catch (Exception cause) {
            throw new InjectionException("Camel annotations post processing of [" + this.delegate + "] failed!", (Throwable)cause);
        }
    }
}

