/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;

final class BeanDelegate<T>
implements Bean<T> {
    private final Bean<T> delegate;
    private final Set<Annotation> qualifiers;

    @SafeVarargs
    BeanDelegate(Bean<T> delegate, Set<? extends Annotation> ... sets) {
        this.delegate = delegate;
        this.qualifiers = new HashSet<Annotation>();
        for (Set<? extends Annotation> set : sets) {
            this.qualifiers.addAll(set);
        }
    }

    public Set<Type> getTypes() {
        return this.delegate.getTypes();
    }

    public Set<Annotation> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public Class<? extends Annotation> getScope() {
        return this.delegate.getScope();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.delegate.getStereotypes();
    }

    public boolean isAlternative() {
        return this.delegate.isAlternative();
    }

    public Class<?> getBeanClass() {
        return this.delegate.getBeanClass();
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.delegate.getInjectionPoints();
    }

    public boolean isNullable() {
        return this.delegate.isNullable();
    }

    public T create(CreationalContext<T> creationalContext) {
        return (T)this.delegate.create(creationalContext);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        this.delegate.destroy(instance, creationalContext);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

