/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.maven;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.maven.ComponentArtifactHelper;
import org.apache.camel.catalog.maven.MavenArtifactProvider;
import org.apache.camel.catalog.maven.OpenURLClassLoader;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.apache.camel.tooling.maven.MavenDownloader;
import org.apache.camel.tooling.maven.MavenDownloaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

@Deprecated(since="4.6.0")
public class DefaultMavenArtifactProvider
implements MavenArtifactProvider {
    private String localRepository;
    private Logger logger;
    private final MavenDownloader downloader;
    private final Map<String, String> repositories = new LinkedHashMap<String, String>();

    public DefaultMavenArtifactProvider() {
        this.downloader = new MavenDownloaderImpl();
        this.downloader.build();
        this.setLog(true);
    }

    public void setLog(boolean log) {
        this.setLogger(log ? LoggerFactory.getLogger(DefaultMavenArtifactProvider.class) : null);
    }

    public void setLogger(Logger logger) {
        this.logger = logger != null ? logger : NOPLogger.NOP_LOGGER;
    }

    @Override
    public void setCacheDirectory(String directory) {
        this.localRepository = directory;
    }

    @Override
    public void addMavenRepository(String name, String url) {
        this.repositories.put(name, url);
    }

    @Override
    public Set<String> addArtifactToCatalog(CamelCatalog camelCatalog, String groupId, String artifactId, String version) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        try {
            MavenDownloader mavenDownloader = this.downloader;
            if (this.localRepository != null) {
                this.logger.debug("Using cache directory: {}", (Object)this.localRepository);
                mavenDownloader = mavenDownloader.customize(this.localRepository, 10000, 1800000);
            }
            this.logger.info("Downloading {}:{}:{}", new Object[]{groupId, artifactId, version});
            try (OpenURLClassLoader classLoader = new OpenURLClassLoader();){
                if (version == null || version.isBlank()) {
                    version = "LATEST";
                }
                String gav = String.format("%s:%s:%s", groupId, artifactId, version);
                LinkedHashSet<String> extraRepositories = new LinkedHashSet<String>(this.repositories.values());
                List artifacts = mavenDownloader.resolveArtifacts(Collections.singletonList(gav), extraRepositories, false, version.contains("SNAPSHOT"));
                for (MavenArtifact ma : artifacts) {
                    classLoader.addURL(ma.getFile().toURI().toURL());
                }
                if (camelCatalog != null) {
                    this.scanCamelComponents(camelCatalog, classLoader, names);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Error during add components from artifact {}:{}:{} due {}", new Object[]{groupId, artifactId, version, e.getMessage(), e});
        }
        return names;
    }

    protected void scanCamelComponents(CamelCatalog camelCatalog, ClassLoader classLoader, Set<String> names) {
        Properties properties = ComponentArtifactHelper.loadComponentProperties(classLoader, this.logger);
        String components = (String)properties.get("components");
        if (components != null) {
            String[] part;
            for (String scheme : part = components.split("\\s")) {
                if (camelCatalog.findComponentNames().contains(scheme)) continue;
                this.findClassName(camelCatalog, classLoader, names, scheme);
            }
        }
    }

    private void findClassName(CamelCatalog camelCatalog, ClassLoader classLoader, Set<String> names, String scheme) {
        String json;
        String javaType = ComponentArtifactHelper.extractComponentJavaType(classLoader, scheme, this.logger);
        if (javaType != null && (json = ComponentArtifactHelper.loadComponentJSonSchema(classLoader, scheme, this.logger)) != null) {
            this.logger.info("Adding component: {}", (Object)scheme);
            camelCatalog.addComponent(scheme, javaType, json);
            names.add(scheme);
        }
    }
}

