/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.truncate.Truncate;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.utils.cassandra.CassandraSessionHolder;
import org.apache.camel.utils.cassandra.CassandraUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="bean", description="Idempotent repository that uses Cassandra table to store message ids. Advice: use LeveledCompaction for this table and tune read/write consistency levels.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
public class CassandraIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraIdempotentRepository.class);
    @Metadata(description="Cassandra session", required=true)
    private CassandraSessionHolder session;
    @Metadata(description="The table name for storing the data", defaultValue="CAMEL_IDEMPOTENT")
    private String table = "CAMEL_IDEMPOTENT";
    @Metadata(description="Values used as primary key prefix. Multiple values can be separated by comma.", displayName="Prefix Primary Key Values")
    private String prefixPKValues;
    @Metadata(description="Primary key columns. Multiple values can be separated by comma.", displayName="Primary Key Columns", javaType="java.lang.String", defaultValue="KEY")
    private String pkColumns = "KEY";
    @Metadata(description="Time to live in seconds used for inserts", displayName="Time to Live")
    private Integer ttl;
    @Metadata(description="Write consistency level", enums="ANY,ONE,TWO,THREE,QUORUM,ALL,LOCAL_ONE,LOCAL_QUORUM,EACH_QUORUM,SERIAL,LOCAL_SERIAL")
    private ConsistencyLevel writeConsistencyLevel;
    @Metadata(description="Read consistency level", enums="ANY,ONE,TWO,THREE,QUORUM,ALL,LOCAL_ONE,LOCAL_QUORUM,EACH_QUORUM,SERIAL,LOCAL_SERIAL")
    private ConsistencyLevel readConsistencyLevel;
    private PreparedStatement insertStatement;
    private PreparedStatement selectStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement truncateStatement;

    public CassandraIdempotentRepository() {
    }

    public CassandraIdempotentRepository(CqlSession session) {
        this.session = new CassandraSessionHolder(session);
    }

    private boolean isKey(ResultSet resultSet) {
        Row row = (Row)resultSet.one();
        if (row == null) {
            LOGGER.debug("No row to check key");
            return false;
        }
        LOGGER.debug("Row with {} columns to check key", (Object)row.getColumnDefinitions());
        int len = this.pkColumns.split(",").length;
        return row.getColumnDefinitions().size() >= len;
    }

    protected final boolean isApplied(ResultSet resultSet) {
        Row row = (Row)resultSet.one();
        return row == null || row.getBoolean("[applied]");
    }

    protected Object[] getPKValues(String key) {
        if (this.prefixPKValues != null) {
            return CassandraUtils.append(this.prefixPKValues.split(","), key);
        }
        return new Object[]{key};
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.session, (String)"session", (Object)((Object)this));
        this.session.start();
        this.initInsertStatement();
        this.initSelectStatement();
        this.initDeleteStatement();
        this.initClearStatement();
    }

    protected void doStop() throws Exception {
        if (this.session != null) {
            this.session.stop();
        }
    }

    protected void initInsertStatement() {
        Insert insert = CassandraUtils.generateInsert(this.table, this.pkColumns.split(","), true, this.ttl);
        SimpleStatement statement = CassandraUtils.applyConsistencyLevel(insert.build(), this.writeConsistencyLevel);
        LOGGER.debug("Generated Insert {}", (Object)statement);
        this.insertStatement = this.getSession().prepare(statement);
    }

    public boolean add(String key) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Inserting key {}", (Object)idValues);
        return this.isApplied(this.getSession().execute((Statement)this.insertStatement.bind(idValues)));
    }

    protected void initSelectStatement() {
        Select select = CassandraUtils.generateSelect(this.table, this.pkColumns.split(","), this.pkColumns.split(","));
        SimpleStatement statement = CassandraUtils.applyConsistencyLevel(select.build(), this.readConsistencyLevel);
        LOGGER.debug("Generated Select {}", (Object)statement);
        this.selectStatement = this.getSession().prepare(statement);
    }

    public boolean contains(String key) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Checking key {}", (Object)idValues);
        return this.isKey(this.getSession().execute((Statement)this.selectStatement.bind(idValues)));
    }

    public boolean confirm(String key) {
        return true;
    }

    protected void initDeleteStatement() {
        Delete delete = CassandraUtils.generateDelete(this.table, this.pkColumns.split(","), true);
        SimpleStatement statement = CassandraUtils.applyConsistencyLevel(delete.build(), this.writeConsistencyLevel);
        LOGGER.debug("Generated Delete {}", (Object)statement);
        this.deleteStatement = this.getSession().prepare(statement);
    }

    public boolean remove(String key) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Deleting key {}", (Object)idValues);
        return this.isApplied(this.getSession().execute((Statement)this.deleteStatement.bind(idValues)));
    }

    protected void initClearStatement() {
        Truncate truncate = CassandraUtils.generateTruncate(this.table);
        SimpleStatement statement = CassandraUtils.applyConsistencyLevel(truncate.build(), this.writeConsistencyLevel);
        LOGGER.debug("Generated truncate for clear operation {}", (Object)statement);
        this.truncateStatement = this.getSession().prepare(statement);
    }

    public void clear() {
        LOGGER.debug("Clear table {}", (Object)this.table);
        this.getSession().execute((Statement)this.truncateStatement.bind(new Object[0]));
    }

    public CqlSession getSession() {
        return this.session.getSession();
    }

    public void setSession(CqlSession session) {
        this.session = new CassandraSessionHolder(session);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public void setWriteConsistencyLevel(ConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(ConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public String getPrefixPKValues() {
        return this.prefixPKValues;
    }

    public void setPrefixPKValues(String prefixPKValues) {
        this.prefixPKValues = prefixPKValues;
    }

    public String getPkColumns() {
        return this.pkColumns;
    }

    public void setPkColumns(String pkColumns) {
        this.pkColumns = pkColumns;
    }
}

