/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.truncate.Truncate;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.utils.cassandra.CassandraSessionHolder;
import org.apache.camel.utils.cassandra.CassandraUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraIdempotentRepository.class);
    private CassandraSessionHolder sessionHolder;
    private String table = "CAMEL_IDEMPOTENT";
    private String[] prefixPKValues = new String[0];
    private String[] pkColumns = new String[]{"KEY"};
    private Integer ttl;
    private ConsistencyLevel writeConsistencyLevel;
    private ConsistencyLevel readConsistencyLevel;
    private PreparedStatement insertStatement;
    private PreparedStatement selectStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement truncateStatement;

    public CassandraIdempotentRepository() {
    }

    public CassandraIdempotentRepository(CqlSession session) {
        this.sessionHolder = new CassandraSessionHolder(session);
    }

    private boolean isKey(ResultSet resultSet) {
        Row row = (Row)resultSet.one();
        if (row == null) {
            LOGGER.debug("No row to check key");
            return false;
        }
        LOGGER.debug("Row with {} columns to check key", (Object)row.getColumnDefinitions());
        return row.getColumnDefinitions().size() >= this.pkColumns.length;
    }

    protected final boolean isApplied(ResultSet resultSet) {
        Row row = (Row)resultSet.one();
        return row == null || row.getBoolean("[applied]");
    }

    protected Object[] getPKValues(String key) {
        return CassandraUtils.append(this.prefixPKValues, key);
    }

    protected void doStart() throws Exception {
        this.sessionHolder.start();
        this.initInsertStatement();
        this.initSelectStatement();
        this.initDeleteStatement();
        this.initClearStatement();
    }

    protected void doStop() throws Exception {
        this.sessionHolder.stop();
    }

    protected void initInsertStatement() {
        Insert insert = CassandraUtils.generateInsert(this.table, this.pkColumns, true, this.ttl);
        SimpleStatement statement = CassandraUtils.applyConsistencyLevel(insert.build(), this.writeConsistencyLevel);
        LOGGER.debug("Generated Insert {}", (Object)statement);
        this.insertStatement = this.getSession().prepare(statement);
    }

    public boolean add(String key) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Inserting key {}", (Object)idValues);
        return this.isApplied(this.getSession().execute((Statement)this.insertStatement.bind(idValues)));
    }

    protected void initSelectStatement() {
        Select select = CassandraUtils.generateSelect(this.table, this.pkColumns, this.pkColumns);
        SimpleStatement statement = CassandraUtils.applyConsistencyLevel(select.build(), this.readConsistencyLevel);
        LOGGER.debug("Generated Select {}", (Object)statement);
        this.selectStatement = this.getSession().prepare(statement);
    }

    public boolean contains(String key) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Checking key {}", (Object)idValues);
        return this.isKey(this.getSession().execute((Statement)this.selectStatement.bind(idValues)));
    }

    public boolean confirm(String key) {
        return true;
    }

    protected void initDeleteStatement() {
        Delete delete = CassandraUtils.generateDelete(this.table, this.pkColumns, true);
        SimpleStatement statement = CassandraUtils.applyConsistencyLevel(delete.build(), this.writeConsistencyLevel);
        LOGGER.debug("Generated Delete {}", (Object)statement);
        this.deleteStatement = this.getSession().prepare(statement);
    }

    public boolean remove(String key) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Deleting key {}", (Object)idValues);
        return this.isApplied(this.getSession().execute((Statement)this.deleteStatement.bind(idValues)));
    }

    protected void initClearStatement() {
        Truncate truncate = CassandraUtils.generateTruncate(this.table);
        SimpleStatement statement = CassandraUtils.applyConsistencyLevel(truncate.build(), this.writeConsistencyLevel);
        LOGGER.debug("Generated truncate for clear operation {}", (Object)statement);
        this.truncateStatement = this.getSession().prepare(statement);
    }

    public void clear() {
        LOGGER.debug("Clear table {}", (Object)this.table);
        this.getSession().execute((Statement)this.truncateStatement.bind(new Object[0]));
    }

    public CqlSession getSession() {
        return this.sessionHolder.getSession();
    }

    public void setSession(CqlSession session) {
        this.sessionHolder = new CassandraSessionHolder(session);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String[] getPKColumns() {
        return this.pkColumns;
    }

    public void setPKColumns(String ... pkColumns) {
        this.pkColumns = pkColumns;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public void setWriteConsistencyLevel(ConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(ConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public String[] getPrefixPKValues() {
        return this.prefixPKValues;
    }

    public void setPrefixPKValues(String[] prefixPKValues) {
        this.prefixPKValues = prefixPKValues;
    }
}

