/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import java.net.InetSocketAddress;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cassandra.CassandraComponent;
import org.apache.camel.component.cassandra.CassandraConstants;
import org.apache.camel.component.cassandra.CassandraConsumer;
import org.apache.camel.component.cassandra.CassandraProducer;
import org.apache.camel.component.cassandra.ResultSetConversionStrategies;
import org.apache.camel.component.cassandra.ResultSetConversionStrategy;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.utils.cassandra.CassandraExtraCodecs;
import org.apache.camel.utils.cassandra.CassandraSessionHolder;

@UriEndpoint(firstVersion="2.15.0", scheme="cql", title="Cassandra CQL", syntax="cql:beanRef:hosts:port/keyspace", category={Category.DATABASE, Category.NOSQL}, headersClass=CassandraConstants.class)
public class CassandraEndpoint
extends ScheduledPollEndpoint {
    private volatile CassandraSessionHolder sessionHolder;
    @UriPath(description="beanRef is defined using bean:id")
    private String beanRef;
    @UriPath
    private String hosts;
    @UriPath
    private Integer port;
    @UriPath
    private String keyspace;
    @UriParam(defaultValue="datacenter1")
    private String datacenter = "datacenter1";
    @UriParam
    private String cql;
    @UriParam(defaultValue="true")
    private boolean prepareStatements = true;
    @UriParam
    private String clusterName;
    @UriParam
    private String username;
    @UriParam
    private String password;
    @UriParam
    private CqlSession session;
    @UriParam
    private DefaultConsistencyLevel consistencyLevel;
    @UriParam
    private String loadBalancingPolicyClass;
    @UriParam
    private ResultSetConversionStrategy resultSetConversionStrategy = ResultSetConversionStrategies.all();
    @UriParam
    private String extraTypeCodecs;

    public CassandraEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public CassandraEndpoint(String uri, CassandraComponent component, CqlSession session, String keyspace) {
        super(uri, (Component)component);
        this.session = session;
        this.keyspace = keyspace;
    }

    public Producer createProducer() throws Exception {
        return new CassandraProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CassandraConsumer consumer = new CassandraConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.session == null && this.beanRef != null) {
            Object bean = CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.beanRef);
            if (bean instanceof CqlSession) {
                this.session = (CqlSession)bean;
                this.keyspace = this.session.getKeyspace().isPresent() ? ((CqlIdentifier)this.session.getKeyspace().get()).toString() : null;
            } else {
                throw new IllegalArgumentException("CQL Bean type should be of type CqlSession but was " + bean);
            }
        }
        if (this.session == null && this.hosts != null) {
            this.session = (CqlSession)this.createSessionBuilder().build();
        }
        this.sessionHolder = new CassandraSessionHolder(this.session);
        this.sessionHolder.start();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.sessionHolder.stop();
    }

    protected CassandraSessionHolder getSessionHolder() {
        return this.sessionHolder;
    }

    protected CqlSessionBuilder createSessionBuilder() {
        CqlSessionBuilder sessionBuilder = CqlSession.builder();
        for (String host : this.hosts.split(",")) {
            sessionBuilder.addContactPoint(new InetSocketAddress(host, this.port == null ? 9042 : this.port));
        }
        if (this.username != null && !this.username.isEmpty() && this.password != null) {
            sessionBuilder.withAuthCredentials(this.username, this.password);
        }
        if (this.loadBalancingPolicyClass != null && !this.loadBalancingPolicyClass.isEmpty()) {
            DriverConfigLoader driverConfigLoader = ((ProgrammaticDriverConfigLoaderBuilder)DriverConfigLoader.programmaticBuilder().withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, this.loadBalancingPolicyClass)).build();
            sessionBuilder.withConfigLoader(driverConfigLoader);
        }
        sessionBuilder.withLocalDatacenter(this.datacenter);
        sessionBuilder.withKeyspace(this.keyspace);
        ClassLoader classLoader = this.getCamelContext().getApplicationContextClassLoader();
        if (classLoader != null) {
            sessionBuilder.withClassLoader(classLoader);
        }
        if (this.extraTypeCodecs != null) {
            String[] c = this.extraTypeCodecs.split(",");
            System.err.println(c.toString());
            for (String codec : c) {
                if (!ObjectHelper.isNotEmpty((Object)((Object)CassandraExtraCodecs.valueOf(codec)))) continue;
                sessionBuilder.addTypeCodecs(new TypeCodec[]{CassandraExtraCodecs.valueOf(codec).codec()});
            }
        }
        return sessionBuilder;
    }

    protected PreparedStatement prepareStatement(String cql) {
        SimpleStatement statement = ((SimpleStatementBuilder)SimpleStatement.builder((String)cql).setConsistencyLevel((ConsistencyLevel)this.consistencyLevel)).build();
        return this.getSessionHolder().getSession().prepare(statement);
    }

    protected PreparedStatement prepareStatement() {
        return this.prepareStatement(this.cql);
    }

    protected void fillMessage(ResultSet resultSet, Message message) {
        message.setBody(this.resultSetConversionStrategy.getBody(resultSet));
    }

    public String getBean() {
        return this.beanRef;
    }

    public void setBean(String beanRef) {
        this.beanRef = beanRef;
    }

    @Deprecated
    public String getBeanRef() {
        return this.beanRef;
    }

    @Deprecated
    public void setBeanRef(String beanRef) {
        this.beanRef = beanRef;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public void setDatacenter(String datacenter) {
        this.datacenter = datacenter;
    }

    public String getCql() {
        return this.cql;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public CqlSession getSession() {
        if (this.session == null) {
            return this.sessionHolder.getSession();
        }
        return this.session;
    }

    public void setSession(CqlSession session) {
        this.session = session;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(DefaultConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public ResultSetConversionStrategy getResultSetConversionStrategy() {
        return this.resultSetConversionStrategy;
    }

    public void setResultSetConversionStrategy(ResultSetConversionStrategy resultSetConversionStrategy) {
        this.resultSetConversionStrategy = resultSetConversionStrategy;
    }

    public boolean isPrepareStatements() {
        return this.prepareStatements;
    }

    public void setPrepareStatements(boolean prepareStatements) {
        this.prepareStatements = prepareStatements;
    }

    public String getLoadBalancingPolicyClass() {
        return this.loadBalancingPolicyClass;
    }

    public void setLoadBalancingPolicyClass(String loadBalancingPolicyClass) {
        this.loadBalancingPolicyClass = loadBalancingPolicyClass;
    }

    public String getExtraTypeCodecs() {
        return this.extraTypeCodecs;
    }

    public void setExtraTypeCodecs(String extraTypeCodecs) {
        this.extraTypeCodecs = extraTypeCodecs;
    }
}

