/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.utils.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;

public class CassandraSessionHolder {
    private final Cluster cluster;
    private Session session;
    private String keyspace;
    private final boolean managedSession;

    public CassandraSessionHolder(Cluster cluster, String keyspace) {
        this.cluster = cluster;
        this.keyspace = keyspace;
        this.managedSession = true;
    }

    public CassandraSessionHolder(Session session) {
        this.cluster = session.getCluster();
        this.session = session;
        this.keyspace = session.getLoggedKeyspace();
        this.managedSession = false;
    }

    public void start() {
        if (this.managedSession) {
            this.session = this.keyspace == null ? this.cluster.connect() : this.cluster.connect(this.keyspace);
        }
    }

    public void stop() {
        if (!this.managedSession) {
            this.session.close();
            this.session = null;
        }
    }

    public Session getSession() {
        return this.session;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public String getKeyspace() {
        return this.keyspace;
    }
}

