/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.CaffeineHelper;
import org.apache.camel.component.caffeine.cache.CaffeineCacheEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="caffeine-cache")
public class CaffeineCacheComponent
extends DefaultComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaffeineCacheComponent.class);
    private final Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    @Metadata(label="advanced")
    private CaffeineConfiguration configuration = new CaffeineConfiguration();

    public CaffeineCacheComponent() {
    }

    public CaffeineCacheComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CaffeineConfiguration configuration = this.configuration.copy();
        CaffeineCacheEndpoint endpoint = new CaffeineCacheEndpoint(uri, (Component)this, remaining, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected Cache<?, ?> getOrCreateCache(String name, CaffeineConfiguration configuration) {
        return this.caches.computeIfAbsent(name, key -> {
            Caffeine builder = Caffeine.newBuilder();
            CaffeineHelper.defineBuilder(builder, configuration);
            return builder.build();
        });
    }

    public CaffeineConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CaffeineConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doShutdown() throws Exception {
        this.caches.clear();
    }
}

