/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.lang.reflect.Field;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheManagerFactory
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CacheManagerFactory.class);
    private CacheManager cacheManager;

    public synchronized CacheManager getInstance() {
        if (this.cacheManager == null) {
            this.cacheManager = this.createCacheManagerInstance();
            LOG.debug("Turning off EHCache update checker ...");
            Configuration config = this.cacheManager.getConfiguration();
            try {
                System.setProperty("net.sf.ehcache.skipUpdateCheck", "true");
                ReflectionHelper.setField((Field)config.getClass().getDeclaredField("updateCheck"), (Object)config, (Object)false);
                LOG.info("Turned off EHCache update checker. updateCheck={}", (Object)config.getUpdateCheck());
            }
            catch (Throwable e) {
                LOG.warn("Error turning off EHCache update checker. Beware information sent over the internet!", e);
            }
        }
        return this.cacheManager;
    }

    protected abstract CacheManager createCacheManagerInstance();

    protected void doStart() throws Exception {
    }

    protected synchronized void doStop() throws Exception {
        if (this.cacheManager != null) {
            int size = this.cacheManager.getCacheNames().length;
            if (size <= 0) {
                LOG.info("Shutting down CacheManager as its no longer in use");
                this.cacheManager.shutdown();
                this.cacheManager = null;
            } else {
                LOG.info("Cannot stop CacheManager as its still in use by {} clients", (Object)size);
            }
        }
    }
}

