/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import net.sf.ehcache.Ehcache;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheEndpoint;
import org.apache.camel.component.cache.CacheEventListener;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CacheConsumer.class);
    private CacheEventListener cacheEventListener;
    private Ehcache cache;

    public CacheConsumer(Endpoint endpoint, Processor processor, CacheConfiguration config) {
        super(endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.createConsumerCacheConnection();
        LOG.debug("initialize the cache");
    }

    protected void doStop() throws Exception {
        this.cache.getCacheEventNotificationService().unregisterListener((net.sf.ehcache.event.CacheEventListener)this.cacheEventListener);
    }

    public CacheEndpoint getEndpoint() {
        return (CacheEndpoint)super.getEndpoint();
    }

    protected void createConsumerCacheConnection() {
        this.cacheEventListener = new CacheEventListener();
        this.cacheEventListener.setCacheConsumer(this);
        this.cache = this.getEndpoint().initializeCache();
        this.cache.getCacheEventNotificationService().registerListener((net.sf.ehcache.event.CacheEventListener)this.cacheEventListener);
    }
}

