/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import com.box.sdk.EncryptionAlgorithm;
import com.box.sdk.IAccessTokenCache;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.internal.BoxApiName;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.jsse.SSLContextParameters;

@UriParams
@Configurer(extended=true)
public class BoxConfiguration {
    public static final String APP_ENTERPRISE_AUTHENTICATION = "APP_ENTERPRISE_AUTHENTICATION";
    public static final String APP_USER_AUTHENTICATION = "APP_USER_AUTHENTICATION";
    public static final String STANDARD_AUTHENTICATION = "STANDARD_AUTHENTICATION";
    public static final String RSA_SHA_512 = "RSA_SHA_512";
    public static final String RSA_SHA_384 = "RSA_SHA_384";
    public static final String RSA_SHA_256 = "RSA_SHA_256";
    @UriPath
    @Metadata(required=true)
    private BoxApiName apiName;
    @UriPath
    @Metadata(required=true)
    private String methodName;
    @UriParam
    private String enterpriseId;
    @UriParam
    private String userId;
    @UriParam
    private String clientId;
    @UriParam(label="security", secret=true)
    private String publicKeyId;
    @UriParam(label="security", secret=true)
    private String privateKeyFile;
    @UriParam(label="security", secret=true)
    private String privateKeyPassword;
    @UriParam(label="security", secret=true)
    private String clientSecret;
    @UriParam(label="security", secret=true)
    private String userName;
    @UriParam(label="security", secret=true)
    private String userPassword;
    @UriParam(label="advanced,security")
    private IAccessTokenCache accessTokenCache;
    @UriParam(label="advanced,security", defaultValue="100")
    private int maxCacheEntries = 100;
    @UriParam(label="advanced,security", defaultValue="RSA_SHA_256")
    private EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.RSA_SHA_256;
    @UriParam(label="authentication", defaultValue="APP_USER_AUTHENTICATION")
    private String authenticationType = "APP_USER_AUTHENTICATION";
    @UriParam(label="advanced")
    private Map<String, Object> httpParams;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;

    public BoxApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(BoxApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPublicKeyId() {
        return this.publicKeyId;
    }

    public void setPublicKeyId(String publicKeyId) {
        this.publicKeyId = publicKeyId;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKey) {
        this.privateKeyFile = privateKey;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int maxCacheEntries) {
        this.maxCacheEntries = maxCacheEntries;
    }

    public void setMaxCacheEntries(String maxCacheEntries) {
        try {
            this.maxCacheEntries = Integer.decode(maxCacheEntries);
        }
        catch (NumberFormatException e) {
            throw new RuntimeCamelException(String.format("Invalid 'maxCacheEntries' value: %s", maxCacheEntries), (Throwable)e);
        }
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case "RSA_SHA_256": {
                this.encryptionAlgorithm = EncryptionAlgorithm.RSA_SHA_256;
                return;
            }
            case "RSA_SHA_384": {
                this.encryptionAlgorithm = EncryptionAlgorithm.RSA_SHA_384;
                return;
            }
            case "RSA_SHA_512": {
                this.encryptionAlgorithm = EncryptionAlgorithm.RSA_SHA_512;
                return;
            }
        }
        throw new RuntimeCamelException(String.format("Invalid Encryption Algorithm: %s", encryptionAlgorithm));
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        switch (authenticationType) {
            case "STANDARD_AUTHENTICATION": 
            case "APP_USER_AUTHENTICATION": 
            case "APP_ENTERPRISE_AUTHENTICATION": {
                this.authenticationType = authenticationType;
                return;
            }
        }
        throw new RuntimeCamelException(String.format("Invalid Authentication Type: %s", authenticationType));
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public Map<String, Object> getHttpParams() {
        return this.httpParams;
    }

    public void setHttpParams(Map<String, Object> httpParams) {
        this.httpParams = httpParams;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public IAccessTokenCache getAccessTokenCache() {
        return this.accessTokenCache;
    }

    public void setAccessTokenCache(IAccessTokenCache accessTokenCache) {
        this.accessTokenCache = accessTokenCache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        BoxConfiguration that = (BoxConfiguration)o;
        return this.maxCacheEntries == that.maxCacheEntries && Objects.equals(this.enterpriseId, that.enterpriseId) && Objects.equals(this.userId, that.userId) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.publicKeyId, that.publicKeyId) && Objects.equals(this.privateKeyFile, that.privateKeyFile) && Objects.equals(this.privateKeyPassword, that.privateKeyPassword) && Objects.equals(this.clientSecret, that.clientSecret) && Objects.equals(this.userName, that.userName) && Objects.equals(this.userPassword, that.userPassword) && Objects.equals(this.accessTokenCache, that.accessTokenCache) && this.encryptionAlgorithm == that.encryptionAlgorithm && Objects.equals(this.authenticationType, that.authenticationType) && Objects.equals(this.httpParams, that.httpParams) && Objects.equals(this.sslContextParameters, that.sslContextParameters);
    }

    public int hashCode() {
        return Objects.hash(this.enterpriseId, this.userId, this.clientId, this.publicKeyId, this.privateKeyFile, this.privateKeyPassword, this.clientSecret, this.userName, this.userPassword, this.accessTokenCache, this.maxCacheEntries, this.encryptionAlgorithm, this.authenticationType, this.httpParams, this.sslContextParameters);
    }
}

