/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.boxjavalibv2.authorization.IAuthSecureStorage;
import com.box.boxjavalibv2.authorization.OAuthRefreshListener;
import com.box.boxjavalibv2.dao.IAuthData;

class OAuthHelperListener
implements OAuthRefreshListener {
    private final IAuthSecureStorage authSecureStorage;
    private final OAuthRefreshListener configListener;
    private String refreshToken;

    public OAuthHelperListener(IAuthSecureStorage authSecureStorage, OAuthRefreshListener configListener) {
        this.authSecureStorage = authSecureStorage;
        this.configListener = configListener;
        if (authSecureStorage != null && authSecureStorage.getAuth() != null) {
            this.refreshToken = authSecureStorage.getAuth().getRefreshToken();
        }
    }

    public void onRefresh(IAuthData newAuthData) {
        if (!(this.authSecureStorage == null || newAuthData != null && newAuthData.getRefreshToken().equals(this.refreshToken))) {
            this.authSecureStorage.saveAuth(newAuthData);
        }
        if (this.configListener != null) {
            this.configListener.onRefresh(newAuthData);
        }
        this.refreshToken = newAuthData != null ? newAuthData.getRefreshToken() : null;
    }
}

