/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxUser;
import com.box.sdk.CreateUserParams;
import com.box.sdk.EmailAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.api.BoxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxUsersManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxUsersManager.class);
    private BoxAPIConnection boxConnection;

    public BoxUsersManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public BoxUser getCurrentUser() {
        try {
            LOG.debug("Getting current user");
            return BoxUser.getCurrentUser((BoxAPIConnection)this.boxConnection);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public List<BoxUser.Info> getAllEnterpriseOrExternalUsers(String filterTerm, String ... fields) {
        try {
            LOG.debug("Getting all enterprise users matching filterTerm={}", (Object)filterTerm);
            ArrayList<BoxUser.Info> users = new ArrayList<BoxUser.Info>();
            Iterable iterable = filterTerm == null ? BoxUser.getAllEnterpriseUsers((BoxAPIConnection)this.boxConnection) : BoxUser.getAllEnterpriseUsers((BoxAPIConnection)this.boxConnection, (String)filterTerm, (String[])fields);
            for (BoxUser.Info info : iterable) {
                users.add(info);
            }
            return users;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxUser createEnterpriseUser(String login, String name, CreateUserParams params) {
        try {
            LOG.debug("Creating enterprise user with login={} name={}", (Object)login, (Object)name);
            BoxHelper.notNull(login, "login");
            BoxHelper.notNull(name, "name");
            if (params != null) {
                return BoxUser.createEnterpriseUser((BoxAPIConnection)this.boxConnection, (String)login, (String)name, (CreateUserParams)params, (String[])new String[0]).getResource();
            }
            return BoxUser.createEnterpriseUser((BoxAPIConnection)this.boxConnection, (String)login, (String)name, (String[])new String[0]).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxUser createAppUser(String name, CreateUserParams params) {
        try {
            LOG.debug("Creating app user with name={}", (Object)name);
            BoxHelper.notNull(name, "name");
            if (params != null) {
                return BoxUser.createAppUser((BoxAPIConnection)this.boxConnection, (String)name, (CreateUserParams)params, (String[])new String[0]).getResource();
            }
            return BoxUser.createAppUser((BoxAPIConnection)this.boxConnection, (String)name, (String[])new String[0]).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxUser.Info getUserInfo(String userId) {
        try {
            LOG.debug("Getting info for user(id={})", (Object)userId);
            BoxHelper.notNull(userId, "userId");
            BoxUser user = new BoxUser(this.boxConnection, userId);
            return user.getInfo(new String[0]);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxUser updateUserInfo(String userId, BoxUser.Info info) {
        try {
            LOG.debug("Updating info for user(id={})", (Object)userId);
            BoxHelper.notNull(userId, "userId");
            BoxHelper.notNull(info, "info");
            BoxUser user = new BoxUser(this.boxConnection, userId);
            user.updateInfo(info, new String[0]);
            return user;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public void deleteUser(String userId, boolean notifyUser, boolean force) {
        try {
            LOG.debug("Deleting user(id={}) notifyUser={} force={}", new Object[]{userId, notifyUser, force});
            BoxHelper.notNull(userId, "userId");
            BoxUser file = new BoxUser(this.boxConnection, userId);
            file.delete(notifyUser, force);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public EmailAlias addUserEmailAlias(String userId, String email) {
        try {
            LOG.debug("Adding email alias '{}' to user(id={})", (Object)email, (Object)userId);
            BoxHelper.notNull(userId, "userId");
            BoxHelper.notNull(email, "email");
            BoxUser user = new BoxUser(this.boxConnection, userId);
            return user.addEmailAlias(email);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public Collection<EmailAlias> getUserEmailAlias(String userId) {
        try {
            LOG.debug("Get email aliases for user(id={})", (Object)userId);
            BoxHelper.notNull(userId, "userId");
            BoxUser user = new BoxUser(this.boxConnection, userId);
            return user.getEmailAliases();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public void deleteUserEmailAlias(String userId, String emailAliasId) {
        try {
            LOG.debug("Deleting email_alias({}) for user(id={})", (Object)emailAliasId, (Object)userId);
            BoxHelper.notNull(userId, "userId");
            BoxHelper.notNull(emailAliasId, "emailAliasId");
            BoxUser user = new BoxUser(this.boxConnection, userId);
            user.deleteEmailAlias(emailAliasId);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxFolder.Info moveFolderToUser(String userId, String sourceUserId) {
        try {
            LOG.debug("Moving root folder for user(id={}) to user(id={})", (Object)sourceUserId, (Object)userId);
            BoxHelper.notNull(userId, "userId");
            BoxHelper.notNull(sourceUserId, "sourceUserId");
            BoxUser user = new BoxUser(this.boxConnection, sourceUserId);
            return user.transferContent(userId);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }
}

