/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxComment;
import com.box.sdk.BoxFile;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxCommentsManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxCommentsManager.class);
    private BoxAPIConnection boxConnection;

    public BoxCommentsManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public BoxFile addFileComment(String fileId, String message) {
        try {
            LOG.debug("Adding comment to file(id={}) to '{}'", (Object)fileId, (Object)message);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (message == null) {
                throw new IllegalArgumentException("Parameter 'message' can not be null");
            }
            BoxFile fileToCommentOn = new BoxFile(this.boxConnection, fileId);
            fileToCommentOn.addComment(message);
            return fileToCommentOn;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public List<BoxComment.Info> getFileComments(String fileId) {
        try {
            LOG.debug("Getting comments of file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getComments();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxComment.Info getCommentInfo(String commentId) {
        try {
            LOG.debug("Getting info for comment(id={})", (Object)commentId);
            if (commentId == null) {
                throw new IllegalArgumentException("Parameter 'commentId' can not be null");
            }
            BoxComment comment = new BoxComment(this.boxConnection, commentId);
            return comment.getInfo();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxComment replyToComment(String commentId, String message) {
        try {
            LOG.debug("Replying to comment(id={}) with message={}", (Object)commentId, (Object)message);
            if (commentId == null) {
                throw new IllegalArgumentException("Parameter 'commentId' can not be null");
            }
            if (message == null) {
                throw new IllegalArgumentException("Parameter 'message' can not be null");
            }
            BoxComment comment = new BoxComment(this.boxConnection, commentId);
            return comment.reply(message).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxComment changeCommentMessage(String commentId, String message) {
        try {
            LOG.debug("Changing comment(id={}) message={}", (Object)commentId, (Object)message);
            if (commentId == null) {
                throw new IllegalArgumentException("Parameter 'commentId' can not be null");
            }
            if (message == null) {
                throw new IllegalArgumentException("Parameter 'message' can not be null");
            }
            BoxComment comment = new BoxComment(this.boxConnection, commentId);
            return comment.changeMessage(message).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public void deleteComment(String commentId) {
        try {
            LOG.debug("Deleting comment(id={})", (Object)commentId);
            if (commentId == null) {
                throw new IllegalArgumentException("Parameter 'commentId' can not be null");
            }
            BoxComment comment = new BoxComment(this.boxConnection, commentId);
            comment.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }
}

