/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint.handler;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.ComponentDefinitionRegistryProcessor;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.EndpointInject;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Produce;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.blueprint.CamelContextFactoryBean;
import org.apache.camel.blueprint.CamelRouteContextFactoryBean;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.core.xml.AbstractCamelContextFactoryBean;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.impl.CamelPostProcessorHelper;
import org.apache.camel.impl.DefaultCamelContextNameStrategy;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.blueprint.KeyStoreParametersFactoryBean;
import org.apache.camel.util.blueprint.SSLContextParametersFactoryBean;
import org.apache.camel.util.blueprint.SecureRandomParametersFactoryBean;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CamelNamespaceHandler
implements NamespaceHandler {
    private static final String CAMEL_CONTEXT = "camelContext";
    private static final String ROUTE_CONTEXT = "routeContext";
    private static final String KEY_STORE_PARAMETERS = "keyStoreParameters";
    private static final String SECURE_RANDOM_PARAMETERS = "secureRandomParameters";
    private static final String SSL_CONTEXT_PARAMETERS = "sslContextParameters";
    private static final String SPRING_NS = "http://camel.apache.org/schema/spring";
    private static final String BLUEPRINT_NS = "http://camel.apache.org/schema/blueprint";
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelNamespaceHandler.class);
    private JAXBContext jaxbContext;

    public static void renameNamespaceRecursive(Node node) {
        if (node.getNodeType() == 1) {
            Document doc = node.getOwnerDocument();
            if (((Element)node).getNamespaceURI().equals(BLUEPRINT_NS)) {
                doc.renameNode(node, SPRING_NS, node.getLocalName());
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            CamelNamespaceHandler.renameNamespaceRecursive(list.item(i));
        }
    }

    public URL getSchemaLocation(String namespace) {
        return this.getClass().getClassLoader().getResource("camel-blueprint.xsd");
    }

    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(BlueprintCamelContext.class));
    }

    public Metadata parse(Element element, ParserContext context) {
        CamelNamespaceHandler.renameNamespaceRecursive(element);
        if (element.getLocalName().equals(CAMEL_CONTEXT)) {
            return this.parseCamelContextNode(element, context);
        }
        if (element.getLocalName().equals(ROUTE_CONTEXT)) {
            return this.parseRouteContextNode(element, context);
        }
        if (element.getLocalName().equals(KEY_STORE_PARAMETERS)) {
            return this.parseKeyStoreParametersNode(element, context);
        }
        if (element.getLocalName().equals(SECURE_RANDOM_PARAMETERS)) {
            return this.parseSecureRandomParametersNode(element, context);
        }
        if (element.getLocalName().equals(SSL_CONTEXT_PARAMETERS)) {
            return this.parseSSLContextParametersNode(element, context);
        }
        return null;
    }

    private Metadata parseCamelContextNode(Element element, ParserContext context) {
        Binder binder;
        String contextId = element.getAttribute("id");
        boolean implicitId = false;
        if (ObjectHelper.isEmpty((Object)contextId)) {
            DefaultCamelContextNameStrategy strategy = new DefaultCamelContextNameStrategy();
            contextId = strategy.getName();
            element.setAttribute("id", contextId);
            implicitId = true;
        }
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder : " + (Object)((Object)e), (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof CamelContextFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + CamelContextFactoryBean.class);
        }
        CamelContextFactoryBean ccfb = (CamelContextFactoryBean)((Object)value);
        ccfb.setImplicitId(implicitId);
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + contextId);
        factory.setObject(new PassThroughCallable<Object>(value));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + contextId);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        factory2.setInitMethod("afterPropertiesSet");
        factory2.setDestroyMethod("destroy");
        factory2.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        factory2.addProperty("bundleContext", (Metadata)this.createRef(context, "blueprintBundleContext"));
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)factory2);
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(contextId);
        ctx.setRuntimeClass(BlueprintCamelContext.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getContext");
        ctx.setInitMethod("init");
        ctx.setDestroyMethod("destroy");
        this.registerBeans(context, contextId, ccfb.getThreadPools());
        this.registerBeans(context, contextId, ccfb.getEndpoints());
        this.registerBeans(context, contextId, ccfb.getRedeliveryPolicies());
        this.registerBeans(context, contextId, ccfb.getBeans());
        MutablePassThroughMetadata beanProcessorFactory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        beanProcessorFactory.setId(".camelBlueprint.processor.bean.passThrough." + contextId);
        beanProcessorFactory.setObject(new PassThroughCallable<CamelInjector>(new CamelInjector(contextId)));
        MutableBeanMetadata beanProcessor = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        beanProcessor.setId(".camelBlueprint.processor.bean." + contextId);
        beanProcessor.setRuntimeClass(CamelInjector.class);
        beanProcessor.setFactoryComponent((Target)beanProcessorFactory);
        beanProcessor.setFactoryMethod("call");
        beanProcessor.setProcessor(true);
        beanProcessor.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)beanProcessor);
        MutablePassThroughMetadata regProcessorFactory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        regProcessorFactory.setId(".camelBlueprint.processor.registry.passThrough." + contextId);
        regProcessorFactory.setObject(new PassThroughCallable<CamelDependenciesFinder>(new CamelDependenciesFinder(contextId, context)));
        MutableBeanMetadata regProcessor = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        regProcessor.setId(".camelBlueprint.processor.registry." + contextId);
        regProcessor.setRuntimeClass(CamelDependenciesFinder.class);
        regProcessor.setFactoryComponent((Target)regProcessorFactory);
        regProcessor.setFactoryMethod("call");
        regProcessor.setProcessor(true);
        regProcessor.addDependsOn(".camelBlueprint.processor.bean." + contextId);
        regProcessor.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)regProcessor);
        this.injectNamespaces(element, (Binder<Node>)binder);
        return ctx;
    }

    protected void injectNamespaces(Element element, Binder<Node> binder) {
        NodeList list = element.getChildNodes();
        Namespaces namespaces = null;
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            Object object = binder.getJAXBNode((Object)child);
            if (object instanceof NamespaceAware) {
                NamespaceAware namespaceAware = (NamespaceAware)object;
                if (namespaces == null) {
                    namespaces = new Namespaces(element);
                }
                namespaces.configure(namespaceAware);
            }
            this.injectNamespaces(childElement, binder);
        }
    }

    private Metadata parseRouteContextNode(Element element, ParserContext context) {
        Binder binder;
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder : " + (Object)((Object)e), (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof CamelRouteContextFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + CamelRouteContextFactoryBean.class);
        }
        CamelRouteContextFactoryBean rcfb = (CamelRouteContextFactoryBean)((Object)value);
        String id = rcfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<CamelRouteContextFactoryBean>(rcfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(List.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getRoutes");
        return ctx;
    }

    private Metadata parseKeyStoreParametersNode(Element element, ParserContext context) {
        Binder binder;
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder : " + (Object)((Object)e), (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof KeyStoreParametersFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + KeyStoreParametersFactoryBean.class);
        }
        KeyStoreParametersFactoryBean kspfb = (KeyStoreParametersFactoryBean)((Object)value);
        String id = kspfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<KeyStoreParametersFactoryBean>(kspfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(List.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getObject");
        return ctx;
    }

    private Metadata parseSecureRandomParametersNode(Element element, ParserContext context) {
        Binder binder;
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder : " + (Object)((Object)e), (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof SecureRandomParametersFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + SecureRandomParametersFactoryBean.class);
        }
        SecureRandomParametersFactoryBean srfb = (SecureRandomParametersFactoryBean)((Object)value);
        String id = srfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<SecureRandomParametersFactoryBean>(srfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(List.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getObject");
        return ctx;
    }

    private Metadata parseSSLContextParametersNode(Element element, ParserContext context) {
        Binder binder;
        try {
            binder = this.getJaxbContext().createBinder();
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to create the JAXB binder : " + (Object)((Object)e), (Throwable)e);
        }
        Object value = this.parseUsingJaxb(element, context, (Binder<Node>)binder);
        if (!(value instanceof SSLContextParametersFactoryBean)) {
            throw new ComponentDefinitionException("Expected an instance of " + SSLContextParametersFactoryBean.class);
        }
        SSLContextParametersFactoryBean scpfb = (SSLContextParametersFactoryBean)((Object)value);
        String id = scpfb.getId();
        MutablePassThroughMetadata factory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        factory.setId(".camelBlueprint.passThrough." + id);
        factory.setObject(new PassThroughCallable<SSLContextParametersFactoryBean>(scpfb));
        MutableBeanMetadata factory2 = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        factory2.setId(".camelBlueprint.factory." + id);
        factory2.setFactoryComponent((Target)factory);
        factory2.setFactoryMethod("call");
        MutableBeanMetadata ctx = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ctx.setId(id);
        ctx.setRuntimeClass(List.class);
        ctx.setFactoryComponent((Target)factory2);
        ctx.setFactoryMethod("getObject");
        return ctx;
    }

    private void registerBeans(ParserContext context, String contextId, List<?> beans) {
        if (beans != null) {
            for (Object bean : beans) {
                if (!(bean instanceof AbstractCamelFactoryBean)) continue;
                this.registerBean(context, contextId, (AbstractCamelFactoryBean)((Object)bean));
            }
        }
    }

    protected void registerBean(ParserContext context, String contextId, AbstractCamelFactoryBean<?> fact) {
        String id = fact.getId();
        fact.setCamelContextId(contextId);
        MutablePassThroughMetadata eff = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        eff.setId(".camelBlueprint.bean.passthrough." + id);
        eff.setObject(new PassThroughCallable(fact));
        MutableBeanMetadata ef = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        ef.setId(".camelBlueprint.bean.factory." + id);
        ef.setFactoryComponent((Target)eff);
        ef.setFactoryMethod("call");
        ef.addProperty("blueprintContainer", (Metadata)this.createRef(context, "blueprintContainer"));
        ef.setInitMethod("afterPropertiesSet");
        ef.setDestroyMethod("destroy");
        MutableBeanMetadata e = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        e.setId(id);
        e.setRuntimeClass(fact.getObjectType());
        e.setFactoryComponent((Target)ef);
        e.setFactoryMethod("getObject");
        e.addDependsOn(".camelBlueprint.processor.bean." + contextId);
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)e);
    }

    protected BlueprintContainer getBlueprintContainer(ParserContext context) {
        PassThroughMetadata ptm = (PassThroughMetadata)context.getComponentDefinitionRegistry().getComponentDefinition("blueprintContainer");
        return (BlueprintContainer)ptm.getObject();
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        return null;
    }

    protected Object parseUsingJaxb(Element element, ParserContext parserContext, Binder<Node> binder) {
        try {
            return binder.unmarshal((Object)element);
        }
        catch (JAXBException e) {
            throw new ComponentDefinitionException("Failed to parse JAXB element: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = this.createJaxbContext();
        }
        return this.jaxbContext;
    }

    protected JAXBContext createJaxbContext() throws JAXBException {
        StringBuilder packages = new StringBuilder();
        for (Class cl : this.getJaxbPackages()) {
            if (packages.length() > 0) {
                packages.append(":");
            }
            packages.append(cl.getName().substring(0, cl.getName().lastIndexOf(46)));
        }
        return JAXBContext.newInstance((String)packages.toString(), (ClassLoader)this.getClass().getClassLoader());
    }

    protected Set<Class> getJaxbPackages() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(CamelContextFactoryBean.class);
        classes.add(AbstractCamelContextFactoryBean.class);
        classes.add(ExchangePattern.class);
        classes.add(RouteDefinition.class);
        classes.add(StreamResequencerConfig.class);
        classes.add(DataFormatsDefinition.class);
        classes.add(ExpressionDefinition.class);
        classes.add(RoundRobinLoadBalancerDefinition.class);
        classes.add(SSLContextParametersFactoryBean.class);
        return classes;
    }

    private RefMetadata createRef(ParserContext context, String value) {
        MutableRefMetadata r = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
        r.setComponentId(value);
        return r;
    }

    public static class CamelDependenciesFinder
    implements ComponentDefinitionRegistryProcessor {
        private final String camelContextName;
        private final ParserContext context;
        private BlueprintContainer blueprintContainer;

        public CamelDependenciesFinder(String camelContextName, ParserContext context) {
            this.camelContextName = camelContextName;
            this.context = context;
        }

        public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
            this.blueprintContainer = blueprintContainer;
        }

        public void process(ComponentDefinitionRegistry componentDefinitionRegistry) {
            CamelContextFactoryBean ccfb = (CamelContextFactoryBean)((Object)this.blueprintContainer.getComponentInstance(".camelBlueprint.factory." + this.camelContextName));
            Object camelContext = ccfb.getContext();
            HashSet<String> components = new HashSet<String>();
            HashSet<String> languages = new HashSet<String>();
            HashSet<String> dataformats = new HashSet<String>();
            HashSet<String> dependsOn = new HashSet<String>();
            for (RouteDefinition rd : camelContext.getRouteDefinitions()) {
                this.findInputComponents(rd.getInputs(), components, languages, dataformats);
                this.findOutputComponents(rd.getOutputs(), components, languages, dataformats);
            }
            try {
                Bundle b;
                PassThroughMetadata ptm;
                MutableReferenceMetadata svc;
                ComponentMetadata cm;
                for (String component : components) {
                    cm = componentDefinitionRegistry.getComponentDefinition(".camelBlueprint.componentResolver." + component);
                    if (cm != null) continue;
                    svc = this.createMetadata(MutableReferenceMetadata.class);
                    svc.setId(".camelBlueprint.componentResolver." + component);
                    svc.setFilter("(component=" + component + ")");
                    svc.setAvailability(componentDefinitionRegistry.containsComponentDefinition(component) ? 2 : 1);
                    try {
                        svc.getClass().getMethod("setRuntimeInterface", Class.class).invoke((Object)svc, ComponentResolver.class);
                    }
                    catch (Throwable t) {
                        try {
                            ptm = (PassThroughMetadata)componentDefinitionRegistry.getComponentDefinition("blueprintBundle");
                            b = (Bundle)ptm.getObject();
                            if (b.loadClass(ComponentResolver.class.getName()) != ComponentResolver.class) {
                                throw new UnsupportedOperationException();
                            }
                            svc.setInterface(ComponentResolver.class.getName());
                        }
                        catch (Throwable t2) {
                            throw new UnsupportedOperationException();
                        }
                    }
                    componentDefinitionRegistry.registerComponentDefinition((ComponentMetadata)svc);
                    dependsOn.add(svc.getId());
                }
                for (String language : languages) {
                    cm = componentDefinitionRegistry.getComponentDefinition(".camelBlueprint.languageResolver." + language);
                    if (cm != null) continue;
                    svc = this.createMetadata(MutableReferenceMetadata.class);
                    svc.setId(".camelBlueprint.languageResolver." + language);
                    svc.setFilter("(language=" + language + ")");
                    svc.setAvailability(componentDefinitionRegistry.containsComponentDefinition(language) ? 2 : 1);
                    try {
                        svc.getClass().getMethod("setRuntimeInterface", Class.class).invoke((Object)svc, LanguageResolver.class);
                    }
                    catch (Throwable t) {
                        try {
                            ptm = (PassThroughMetadata)componentDefinitionRegistry.getComponentDefinition("blueprintBundle");
                            b = (Bundle)ptm.getObject();
                            if (b.loadClass(LanguageResolver.class.getName()) != LanguageResolver.class) {
                                throw new UnsupportedOperationException();
                            }
                            svc.setInterface(LanguageResolver.class.getName());
                        }
                        catch (Throwable t2) {
                            throw new UnsupportedOperationException();
                        }
                    }
                    componentDefinitionRegistry.registerComponentDefinition((ComponentMetadata)svc);
                    dependsOn.add(svc.getId());
                }
                for (String dataformat : dataformats) {
                    cm = componentDefinitionRegistry.getComponentDefinition(".camelBlueprint.dataformatResolver." + dataformat);
                    if (cm != null) continue;
                    svc = this.createMetadata(MutableReferenceMetadata.class);
                    svc.setId(".camelBlueprint.dataformatResolver." + dataformat);
                    svc.setFilter("(dataformat=" + dataformat + ")");
                    svc.setAvailability(componentDefinitionRegistry.containsComponentDefinition(dataformat) ? 2 : 1);
                    try {
                        svc.getClass().getMethod("setRuntimeInterface", Class.class).invoke((Object)svc, DataFormatResolver.class);
                    }
                    catch (Throwable t) {
                        try {
                            ptm = (PassThroughMetadata)componentDefinitionRegistry.getComponentDefinition("blueprintBundle");
                            b = (Bundle)ptm.getObject();
                            if (b.loadClass(DataFormatResolver.class.getName()) != DataFormatResolver.class) {
                                throw new UnsupportedOperationException();
                            }
                            svc.setInterface(DataFormatResolver.class.getName());
                        }
                        catch (Throwable t2) {
                            throw new UnsupportedOperationException();
                        }
                    }
                    componentDefinitionRegistry.registerComponentDefinition((ComponentMetadata)svc);
                    dependsOn.add(svc.getId());
                }
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("Unable to add dependencies on to camel components OSGi services.  The Apache Aries blueprint implementation used it too old and the blueprint bundle can not see the org.apache.camel.spi package.");
                components.clear();
                languages.clear();
                dataformats.clear();
            }
        }

        public <T extends Metadata> T createMetadata(Class<T> tClass) {
            return (T)this.context.createMetadata(tClass);
        }

        private void findInputComponents(List<FromDefinition> defs, Set<String> components, Set<String> languages, Set<String> dataformats) {
            if (defs != null) {
                for (FromDefinition def : defs) {
                    this.findUriComponent(def.getUri(), components);
                }
            }
        }

        private void findOutputComponents(List<ProcessorDefinition> defs, Set<String> components, Set<String> languages, Set<String> dataformats) {
            if (defs != null) {
                for (ProcessorDefinition def : defs) {
                    if (def instanceof SendDefinition) {
                        this.findUriComponent(((SendDefinition)def).getUri(), components);
                    }
                    if (def instanceof MarshalDefinition) {
                        this.findDataFormat(((MarshalDefinition)def).getDataFormatType(), dataformats);
                    }
                    if (def instanceof UnmarshalDefinition) {
                        this.findDataFormat(((UnmarshalDefinition)def).getDataFormatType(), dataformats);
                    }
                    if (def instanceof ExpressionNode) {
                        this.findLanguage(((ExpressionNode)def).getExpression(), languages);
                    }
                    if (def instanceof ResequenceDefinition) {
                        this.findLanguage(((ResequenceDefinition)def).getExpression(), languages);
                    }
                    if (def instanceof AggregateDefinition) {
                        this.findLanguage(((AggregateDefinition)def).getExpression(), languages);
                        this.findLanguage(((AggregateDefinition)def).getCorrelationExpression(), languages);
                        this.findLanguage(((AggregateDefinition)def).getCompletionPredicate(), languages);
                        this.findLanguage(((AggregateDefinition)def).getCompletionTimeoutExpression(), languages);
                        this.findLanguage(((AggregateDefinition)def).getCompletionSizeExpression(), languages);
                    }
                    if (def instanceof CatchDefinition) {
                        this.findLanguage(((CatchDefinition)def).getHandled(), languages);
                    }
                    if (def instanceof OnExceptionDefinition) {
                        this.findLanguage(((OnExceptionDefinition)def).getRetryWhile(), languages);
                        this.findLanguage(((OnExceptionDefinition)def).getHandled(), languages);
                        this.findLanguage(((OnExceptionDefinition)def).getContinued(), languages);
                    }
                    if (def instanceof SortDefinition) {
                        this.findLanguage(((SortDefinition)def).getExpression(), languages);
                    }
                    if (def instanceof WireTapDefinition) {
                        this.findLanguage(((WireTapDefinition)def).getNewExchangeExpression(), languages);
                    }
                    this.findOutputComponents(def.getOutputs(), components, languages, dataformats);
                }
            }
        }

        private void findLanguage(ExpressionDefinition expression, Set<String> languages) {
            String lang;
            if (expression != null && (lang = expression.getLanguage()) != null && lang.length() > 0) {
                languages.add(lang);
            }
        }

        private void findLanguage(ExpressionSubElementDefinition expression, Set<String> languages) {
            if (expression != null) {
                this.findLanguage(expression.getExpressionType(), languages);
            }
        }

        private void findDataFormat(DataFormatDefinition dfd, Set<String> dataformats) {
            if (dfd != null && dfd.getDataFormatName() != null) {
                dataformats.add(dfd.getDataFormatName());
            }
        }

        private void findUriComponent(String uri, Set<String> components) {
            String[] splitURI;
            if (uri != null && (splitURI = ObjectHelper.splitOnCharacter((String)uri, (String)":", (int)2))[1] != null) {
                String scheme = splitURI[0];
                components.add(scheme);
            }
        }
    }

    public static class CamelInjector
    extends CamelPostProcessorHelper
    implements BeanProcessor {
        private final String camelContextName;
        private BlueprintContainer blueprintContainer;

        public CamelInjector(String camelContextName) {
            this.camelContextName = camelContextName;
        }

        public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
            this.blueprintContainer = blueprintContainer;
        }

        public Object beforeInit(Object bean, String beanName, BeanProcessor.BeanCreator beanCreator, BeanMetadata beanMetadata) {
            this.injectFields(bean, beanName);
            this.injectMethods(bean, beanName);
            if (bean instanceof CamelContextAware) {
                ((CamelContextAware)bean).setCamelContext(this.getCamelContext());
            }
            return bean;
        }

        public CamelContext getCamelContext() {
            return (CamelContext)this.blueprintContainer.getComponentInstance(this.camelContextName);
        }

        protected void injectFields(Object bean, String beanName) {
            Class<?> clazz = bean.getClass();
            do {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    Produce produce;
                    EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
                    if (endpointInject != null && this.matchContext(endpointInject.context())) {
                        this.injectField(field, endpointInject.uri(), endpointInject.ref(), bean, beanName);
                    }
                    if ((produce = field.getAnnotation(Produce.class)) == null || !this.matchContext(produce.context())) continue;
                    this.injectField(field, produce.uri(), produce.ref(), bean, beanName);
                }
            } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        }

        protected void injectField(Field field, String endpointUri, String endpointRef, Object bean, String beanName) {
            CamelInjector.setField(field, bean, this.getInjectionValue(field.getType(), endpointUri, endpointRef, field.getName(), bean, beanName));
        }

        protected static void setField(Field field, Object instance, Object value) {
            try {
                boolean shouldSetAccessible;
                boolean oldAccessible = field.isAccessible();
                boolean bl = shouldSetAccessible = !Modifier.isPublic(field.getModifiers()) && !oldAccessible;
                if (shouldSetAccessible) {
                    field.setAccessible(true);
                }
                field.set(instance, value);
                if (shouldSetAccessible) {
                    field.setAccessible(oldAccessible);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new UnsupportedOperationException("Cannot inject value of class: " + value.getClass() + " into: " + field);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Could not access method: " + ex.getMessage());
            }
        }

        protected void injectMethods(Object bean, String beanName) {
            Class<?> clazz = bean.getClass();
            do {
                Method[] methods;
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    this.setterInjection(method, bean, beanName);
                    this.consumerInjection(method, bean, beanName);
                }
            } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        }

        protected void setterInjection(Method method, Object bean, String beanName) {
            Produce produce;
            EndpointInject endpointInject = method.getAnnotation(EndpointInject.class);
            if (endpointInject != null && this.matchContext(endpointInject.context())) {
                this.setterInjection(method, bean, beanName, endpointInject.uri(), endpointInject.ref());
            }
            if ((produce = method.getAnnotation(Produce.class)) != null && this.matchContext(produce.context())) {
                this.setterInjection(method, bean, beanName, produce.uri(), produce.ref());
            }
        }

        protected void setterInjection(Method method, Object bean, String beanName, String endpointUri, String endpointRef) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes != null) {
                if (parameterTypes.length != 1) {
                    LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: " + method);
                } else {
                    String propertyName = ObjectHelper.getPropertyName((Method)method);
                    Object value = this.getInjectionValue(parameterTypes[0], endpointUri, endpointRef, propertyName, bean, beanName);
                    ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
                }
            }
        }

        public Object afterInit(Object o, String s, BeanProcessor.BeanCreator beanCreator, BeanMetadata beanMetadata) {
            return o;
        }

        public void beforeDestroy(Object o, String s) {
        }

        public void afterDestroy(Object o, String s) {
        }
    }

    public static class PassThroughCallable<T>
    implements Callable<T> {
        private T value;

        public PassThroughCallable(T value) {
            this.value = value;
        }

        @Override
        public T call() throws Exception {
            return this.value;
        }
    }
}

