/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.blueprint.BlueprintComponentResolver;
import org.apache.camel.blueprint.BlueprintContainerRegistry;
import org.apache.camel.blueprint.BlueprintDataFormatResolver;
import org.apache.camel.blueprint.BlueprintLanguageResolver;
import org.apache.camel.core.osgi.OsgiCamelContextHelper;
import org.apache.camel.core.osgi.OsgiCamelContextNameStrategy;
import org.apache.camel.core.osgi.OsgiClassResolver;
import org.apache.camel.core.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.core.osgi.OsgiPackageScanClassResolver;
import org.apache.camel.core.osgi.OsgiTypeConverter;
import org.apache.camel.core.osgi.utils.BundleContextUtils;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintCamelContext
extends DefaultCamelContext {
    private static final transient Logger LOG = LoggerFactory.getLogger(BlueprintCamelContext.class);
    private BundleContext bundleContext;
    private BlueprintContainer blueprintContainer;

    public BlueprintCamelContext() {
    }

    public BlueprintCamelContext(BundleContext bundleContext, BlueprintContainer blueprintContainer) {
        this.bundleContext = bundleContext;
        this.blueprintContainer = blueprintContainer;
        this.setNameStrategy((CamelContextNameStrategy)new OsgiCamelContextNameStrategy(bundleContext));
        this.setClassResolver((ClassResolver)new OsgiClassResolver(bundleContext));
        this.setFactoryFinderResolver(new OsgiFactoryFinderResolver(bundleContext));
        this.setPackageScanClassResolver((PackageScanClassResolver)new OsgiPackageScanClassResolver(bundleContext));
        this.setComponentResolver(new BlueprintComponentResolver(bundleContext));
        this.setLanguageResolver(new BlueprintLanguageResolver(bundleContext));
        this.setDataFormatResolver(new BlueprintDataFormatResolver(bundleContext));
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public void init() throws Exception {
        this.maybeStart();
    }

    private void maybeStart() throws Exception {
        if (!this.isStarted() && !this.isStarting()) {
            this.start();
        } else {
            LOG.trace("Ignoring maybeStart() as Apache Camel is already started");
        }
    }

    public void destroy() throws Exception {
        this.stop();
    }

    protected TypeConverter createTypeConverter() {
        BundleContext ctx = BundleContextUtils.getBundleContext(((Object)((Object)this)).getClass());
        if (ctx == null) {
            ctx = this.bundleContext;
        }
        FactoryFinder finder = new OsgiFactoryFinderResolver(this.bundleContext).resolveDefaultFactoryFinder(this.getClassResolver());
        return new OsgiTypeConverter(ctx, this.getInjector(), finder);
    }

    protected Registry createRegistry() {
        BlueprintContainerRegistry reg = new BlueprintContainerRegistry(this.getBlueprintContainer());
        return OsgiCamelContextHelper.wrapRegistry((CamelContext)this, reg, this.bundleContext);
    }
}

