/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.aries.blueprint.ExtendedBlueprintContainer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.blueprint.BlueprintContainerRegistry;
import org.apache.camel.blueprint.BlueprintPropertiesParser;
import org.apache.camel.blueprint.BlueprintPropertiesResolver;
import org.apache.camel.blueprint.CamelConsumerTemplateFactoryBean;
import org.apache.camel.blueprint.CamelEndpointFactoryBean;
import org.apache.camel.blueprint.CamelErrorHandlerFactoryBean;
import org.apache.camel.blueprint.CamelProducerTemplateFactoryBean;
import org.apache.camel.blueprint.CamelProxyFactoryBean;
import org.apache.camel.blueprint.CamelRedeliveryPolicyFactoryBean;
import org.apache.camel.blueprint.CamelThreadPoolFactoryBean;
import org.apache.camel.blueprint.ContextScanRouteBuilderFinder;
import org.apache.camel.blueprint.PackageScanRouteBuilderFinder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.core.osgi.OsgiCamelContextPublisher;
import org.apache.camel.core.osgi.OsgiEventAdminNotifier;
import org.apache.camel.core.osgi.utils.BundleDelegatingClassLoader;
import org.apache.camel.core.xml.AbstractCamelContextFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.CamelServiceExporterDefinition;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.config.PropertiesDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.Registry;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends AbstractCamelContextFactoryBean<BlueprintCamelContext> {
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextFactoryBean.class);
    @XmlAttribute(name="depends-on", required=false)
    private String dependsOn;
    @XmlAttribute(required=false)
    private String trace;
    @XmlAttribute(required=false)
    private String streamCache = "false";
    @XmlAttribute(required=false)
    private String delayer;
    @XmlAttribute(required=false)
    private String handleFault;
    @XmlAttribute(required=false)
    private String errorHandlerRef;
    @XmlAttribute(required=false)
    private String autoStartup = "true";
    @XmlAttribute(required=false)
    private String useMDCLogging;
    @XmlAttribute(required=false)
    private Boolean useBlueprintPropertyResolver;
    @XmlAttribute(required=false)
    private ShutdownRoute shutdownRoute;
    @XmlAttribute(required=false)
    private ShutdownRunningTask shutdownRunningTask;
    @XmlAttribute(required=false)
    private Boolean lazyLoadTypeConverters = Boolean.FALSE;
    @XmlElement(name="properties", required=false)
    private PropertiesDefinition properties;
    @XmlElement(name="propertyPlaceholder", type=CamelPropertyPlaceholderDefinition.class, required=false)
    private CamelPropertyPlaceholderDefinition camelPropertyPlaceholder;
    @XmlElement(name="package", required=false)
    private String[] packages = new String[0];
    @XmlElement(name="packageScan", type=PackageScanDefinition.class, required=false)
    private PackageScanDefinition packageScan;
    @XmlElement(name="contextScan", type=ContextScanDefinition.class, required=false)
    private ContextScanDefinition contextScan;
    @XmlElement(name="jmxAgent", type=CamelJMXAgentDefinition.class, required=false)
    private CamelJMXAgentDefinition camelJMXAgent;
    @XmlElements(value={@XmlElement(name="template", type=CamelProducerTemplateFactoryBean.class, required=false), @XmlElement(name="consumerTemplate", type=CamelConsumerTemplateFactoryBean.class, required=false), @XmlElement(name="proxy", type=CamelProxyFactoryBean.class, required=false), @XmlElement(name="export", type=CamelServiceExporterDefinition.class, required=false), @XmlElement(name="errorHandler", type=CamelErrorHandlerFactoryBean.class, required=false)})
    private List beans;
    @XmlElement(name="routeBuilder", required=false)
    private List<RouteBuilderDefinition> builderRefs = new ArrayList<RouteBuilderDefinition>();
    @XmlElement(name="routeContextRef", required=false)
    private List<RouteContextRefDefinition> routeRefs = new ArrayList<RouteContextRefDefinition>();
    @XmlElement(name="threadPoolProfile", required=false)
    private List<ThreadPoolProfileDefinition> threadPoolProfiles;
    @XmlElement(name="threadPool", required=false)
    private List<CamelThreadPoolFactoryBean> threadPools;
    @XmlElement(name="endpoint", required=false)
    private List<CamelEndpointFactoryBean> endpoints;
    @XmlElement(name="dataFormats", required=false)
    private DataFormatsDefinition dataFormats;
    @XmlElement(name="redeliveryPolicyProfile", required=false)
    private List<CamelRedeliveryPolicyFactoryBean> redeliveryPolicies;
    @XmlElement(name="onException", required=false)
    private List<OnExceptionDefinition> onExceptions = new ArrayList<OnExceptionDefinition>();
    @XmlElement(name="onCompletion", required=false)
    private List<OnCompletionDefinition> onCompletions = new ArrayList<OnCompletionDefinition>();
    @XmlElement(name="intercept", required=false)
    private List<InterceptDefinition> intercepts = new ArrayList<InterceptDefinition>();
    @XmlElement(name="interceptFrom", required=false)
    private List<InterceptFromDefinition> interceptFroms = new ArrayList<InterceptFromDefinition>();
    @XmlElement(name="interceptSendToEndpoint", required=false)
    private List<InterceptSendToEndpointDefinition> interceptSendToEndpoints = new ArrayList<InterceptSendToEndpointDefinition>();
    @XmlElement(name="route", required=false)
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    @XmlTransient
    private BlueprintCamelContext context;
    @XmlTransient
    private BlueprintContainer blueprintContainer;
    @XmlTransient
    private BundleContext bundleContext;
    @XmlTransient
    private boolean implicitId;

    @Override
    public Class getObjectType() {
        return BlueprintCamelContext.class;
    }

    @Override
    public BlueprintCamelContext getContext(boolean create) {
        if (this.context == null && create) {
            this.context = this.createContext();
            if (!this.isImplicitId()) {
                this.context.setName(this.getId());
            }
        }
        return this.context;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected BlueprintCamelContext createContext() {
        return new BlueprintCamelContext(this.bundleContext, this.blueprintContainer);
    }

    @Override
    protected void initCustomRegistry(BlueprintCamelContext context) {
        Registry registry = this.getBeanForType(Registry.class);
        if (registry != null) {
            LOG.info("Using custom Registry: " + registry);
            context.setRegistry(registry);
        }
    }

    @Override
    protected <S> S getBeanForType(Class<S> clazz) {
        Collection<S> objects = BlueprintContainerRegistry.lookupByType(this.blueprintContainer, clazz).values();
        if (objects.size() == 1) {
            return objects.iterator().next();
        }
        return null;
    }

    @Override
    protected void initPropertyPlaceholder() throws Exception {
        super.initPropertyPlaceholder();
        if (this.isUseBlueprintPropertyResolver()) {
            PropertiesComponent pc = (PropertiesComponent)((BlueprintCamelContext)((Object)this.getContext())).getComponent("properties", PropertiesComponent.class);
            BlueprintPropertiesParser parser = new BlueprintPropertiesParser(this.blueprintContainer, pc.getPropertiesParser());
            BlueprintPropertiesResolver resolver = new BlueprintPropertiesResolver(pc.getPropertiesResolver(), parser);
            if (pc.getLocations() == null) {
                String[] ids;
                StringBuilder sb = new StringBuilder();
                for (String id : ids = parser.lookupPropertyPlaceholderIds()) {
                    sb.append("blueprint:").append(id).append(",");
                }
                pc.setLocation(sb.toString());
            }
            if (pc.getLocations() != null) {
                pc.setPropertiesParser((PropertiesParser)parser);
                pc.setPropertiesResolver((PropertiesResolver)resolver);
            }
        }
    }

    @Override
    protected void initBeanPostProcessor(BlueprintCamelContext context) {
    }

    @Override
    protected void postProcessBeforeInit(RouteBuilder builder) {
    }

    @Override
    protected void findRouteBuildersByPackageScan(String[] packages, PackageScanFilter filter, List<RoutesBuilder> builders) throws Exception {
        ((BlueprintCamelContext)((Object)this.getContext())).getPackageScanClassResolver().addFilter(filter);
        BundleDelegatingClassLoader classLoader = new BundleDelegatingClassLoader(((ExtendedBlueprintContainer)this.blueprintContainer).getBundleContext().getBundle());
        PackageScanRouteBuilderFinder finder = new PackageScanRouteBuilderFinder((BlueprintCamelContext)((Object)this.getContext()), packages, classLoader, ((BlueprintCamelContext)((Object)this.getContext())).getPackageScanClassResolver());
        finder.appendBuilders(builders);
        ((BlueprintCamelContext)((Object)this.getContext())).getPackageScanClassResolver().removeFilter(filter);
    }

    @Override
    protected void findRouteBuildersByContextScan(PackageScanFilter filter, List<RoutesBuilder> builders) throws Exception {
        ContextScanRouteBuilderFinder finder = new ContextScanRouteBuilderFinder((BlueprintCamelContext)((Object)this.getContext()), filter);
        finder.appendBuilders(builders);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        ((BlueprintCamelContext)((Object)this.getContext())).getManagementStrategy().addEventNotifier((EventNotifier)new OsgiCamelContextPublisher(this.bundleContext));
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            ((BlueprintCamelContext)((Object)this.getContext())).getManagementStrategy().addEventNotifier((EventNotifier)new OsgiEventAdminNotifier(this.bundleContext));
        }
        catch (Throwable t) {
            LOG.debug("EventAdmin package is not available, just don't use it");
        }
    }

    @Override
    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    @Override
    public String getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(String autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public String getUseMDCLogging() {
        return this.useMDCLogging;
    }

    public void setUseMDCLogging(String useMDCLogging) {
        this.useMDCLogging = useMDCLogging;
    }

    @Override
    public Boolean getLazyLoadTypeConverters() {
        return this.lazyLoadTypeConverters;
    }

    public void setLazyLoadTypeConverters(Boolean lazyLoadTypeConverters) {
        this.lazyLoadTypeConverters = lazyLoadTypeConverters;
    }

    @Override
    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    @Override
    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    @Override
    public CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder() {
        return this.camelPropertyPlaceholder;
    }

    public void setCamelPropertyPlaceholder(CamelPropertyPlaceholderDefinition camelPropertyPlaceholder) {
        this.camelPropertyPlaceholder = camelPropertyPlaceholder;
    }

    @Override
    public List<RouteContextRefDefinition> getRouteRefs() {
        return this.routeRefs;
    }

    public void setRouteRefs(List<RouteContextRefDefinition> routeRefs) {
        this.routeRefs = routeRefs;
    }

    @Override
    public List<CamelRedeliveryPolicyFactoryBean> getRedeliveryPolicies() {
        return this.redeliveryPolicies;
    }

    public void setRedeliveryPolicies(List<CamelRedeliveryPolicyFactoryBean> redeliveryPolicies) {
        this.redeliveryPolicies = redeliveryPolicies;
    }

    @Override
    public List<ThreadPoolProfileDefinition> getThreadPoolProfiles() {
        return this.threadPoolProfiles;
    }

    public void setThreadPoolProfiles(List<ThreadPoolProfileDefinition> threadPoolProfiles) {
        this.threadPoolProfiles = threadPoolProfiles;
    }

    public List<CamelThreadPoolFactoryBean> getThreadPools() {
        return this.threadPools;
    }

    public void setThreadPools(List<CamelThreadPoolFactoryBean> threadPools) {
        this.threadPools = threadPools;
    }

    @Override
    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    @Override
    public String getStreamCache() {
        return this.streamCache;
    }

    public void setStreamCache(String streamCache) {
        this.streamCache = streamCache;
    }

    @Override
    public String getDelayer() {
        return this.delayer;
    }

    public void setDelayer(String delayer) {
        this.delayer = delayer;
    }

    @Override
    public String getHandleFault() {
        return this.handleFault;
    }

    public void setHandleFault(String handleFault) {
        this.handleFault = handleFault;
    }

    @Override
    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
    }

    @Override
    public PropertiesDefinition getProperties() {
        return this.properties;
    }

    public void setProperties(PropertiesDefinition properties) {
        this.properties = properties;
    }

    @Override
    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    @Override
    public PackageScanDefinition getPackageScan() {
        return this.packageScan;
    }

    @Override
    public void setPackageScan(PackageScanDefinition packageScan) {
        this.packageScan = packageScan;
    }

    @Override
    public ContextScanDefinition getContextScan() {
        return this.contextScan;
    }

    @Override
    public void setContextScan(ContextScanDefinition contextScan) {
        this.contextScan = contextScan;
    }

    @Override
    public CamelJMXAgentDefinition getCamelJMXAgent() {
        return this.camelJMXAgent;
    }

    public void setCamelJMXAgent(CamelJMXAgentDefinition camelJMXAgent) {
        this.camelJMXAgent = camelJMXAgent;
    }

    public List getBeans() {
        return this.beans;
    }

    public void setBeans(List beans) {
        this.beans = beans;
    }

    @Override
    public List<RouteBuilderDefinition> getBuilderRefs() {
        return this.builderRefs;
    }

    public void setBuilderRefs(List<RouteBuilderDefinition> builderRefs) {
        this.builderRefs = builderRefs;
    }

    @Override
    public List<CamelEndpointFactoryBean> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<CamelEndpointFactoryBean> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public DataFormatsDefinition getDataFormats() {
        return this.dataFormats;
    }

    public void setDataFormats(DataFormatsDefinition dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public List<OnExceptionDefinition> getOnExceptions() {
        return this.onExceptions;
    }

    public void setOnExceptions(List<OnExceptionDefinition> onExceptions) {
        this.onExceptions = onExceptions;
    }

    @Override
    public List<OnCompletionDefinition> getOnCompletions() {
        return this.onCompletions;
    }

    public void setOnCompletions(List<OnCompletionDefinition> onCompletions) {
        this.onCompletions = onCompletions;
    }

    @Override
    public List<InterceptDefinition> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptDefinition> intercepts) {
        this.intercepts = intercepts;
    }

    @Override
    public List<InterceptFromDefinition> getInterceptFroms() {
        return this.interceptFroms;
    }

    public void setInterceptFroms(List<InterceptFromDefinition> interceptFroms) {
        this.interceptFroms = interceptFroms;
    }

    @Override
    public List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints() {
        return this.interceptSendToEndpoints;
    }

    public void setInterceptSendToEndpoints(List<InterceptSendToEndpointDefinition> interceptSendToEndpoints) {
        this.interceptSendToEndpoints = interceptSendToEndpoints;
    }

    @Override
    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
    }

    public boolean isImplicitId() {
        return this.implicitId;
    }

    public void setImplicitId(boolean flag) {
        this.implicitId = flag;
    }

    public Boolean getUseBlueprintPropertyResolver() {
        return this.useBlueprintPropertyResolver;
    }

    public void setUseBlueprintPropertyResolver(Boolean useBlueprintPropertyResolver) {
        this.useBlueprintPropertyResolver = useBlueprintPropertyResolver;
    }

    public boolean isUseBlueprintPropertyResolver() {
        return this.useBlueprintPropertyResolver == null || this.useBlueprintPropertyResolver != false;
    }
}

