/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.xml.TimeUnitAdapter;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.util.ObjectHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelThreadPoolFactoryBean
extends IdentifiedType
implements CamelContextAware {
    @XmlAttribute(required=true)
    private Integer poolSize;
    @XmlAttribute
    private Integer maxPoolSize;
    @XmlAttribute
    private Long keepAliveTime = 60L;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=TimeUnitAdapter.class)
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    @XmlAttribute
    private Integer maxQueueSize = -1;
    @XmlAttribute
    private ThreadPoolRejectedPolicy rejectedPolicy = ThreadPoolRejectedPolicy.CallerRuns;
    @XmlAttribute(required=true)
    private String threadName;
    @XmlAttribute
    private Boolean daemon = Boolean.TRUE;
    @XmlAttribute
    private String camelContextId;
    @XmlTransient
    private CamelContext camelContext;

    public Object getObject() throws Exception {
        if (this.camelContext == null && this.camelContextId != null) {
            this.camelContext = this.getCamelContextWithId(this.camelContextId);
        }
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        if (this.poolSize == null || this.poolSize <= 0) {
            throw new IllegalArgumentException("PoolSize must be a positive number");
        }
        int max = this.getMaxPoolSize() != null ? this.getMaxPoolSize() : this.getPoolSize();
        RejectedExecutionHandler rejected = null;
        if (this.rejectedPolicy != null) {
            rejected = this.rejectedPolicy.asRejectedExecutionHandler();
        }
        ExecutorService answer = this.camelContext.getExecutorServiceStrategy().newThreadPool((Object)this.getId(), this.getThreadName(), this.getPoolSize().intValue(), max, this.getKeepAliveTime().longValue(), this.getTimeUnit(), this.getMaxQueueSize().intValue(), rejected, this.isDaemon().booleanValue());
        return answer;
    }

    protected abstract CamelContext getCamelContextWithId(String var1);

    public Class getObjectType() {
        return ExecutorService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Integer getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public Long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(Long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public ThreadPoolRejectedPolicy getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public void setRejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public Boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(Boolean daemon) {
        this.daemon = daemon;
    }

    public String getCamelContextId() {
        return this.camelContextId;
    }

    public void setCamelContextId(String camelContextId) {
        this.camelContextId = camelContextId;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

