/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.core.osgi.OsgiComponentResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class BlueprintComponentResolver
extends OsgiComponentResolver {
    private static final transient Log LOG = LogFactory.getLog(BlueprintComponentResolver.class);

    public BlueprintComponentResolver(BundleContext bundleContext) {
        super(bundleContext);
    }

    public Component resolveComponent(String name, CamelContext context) throws Exception {
        try {
            Object bean = context.getRegistry().lookup(".camelBlueprint.componentResolver." + name);
            if (bean instanceof ComponentResolver) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found component resolver: " + name + " in registry: " + bean));
                }
                return ((ComponentResolver)bean).resolveComponent(name, context);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Ignored error looking up bean: " + name + ". Error: " + e));
        }
        return super.resolveComponent(name, context);
    }
}

