/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.aries.blueprint.ExtendedBeanMetadata;
import org.apache.aries.blueprint.ext.AbstractPropertyPlaceholder;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.util.ObjectHelper;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

public class BlueprintPropertiesParser
extends DefaultPropertiesParser {
    private final PropertiesComponent propertiesComponent;
    private final BlueprintContainer container;
    private final PropertiesParser delegate;
    private final Set<AbstractPropertyPlaceholder> placeholders = new LinkedHashSet<AbstractPropertyPlaceholder>();
    private Method method;

    public BlueprintPropertiesParser(PropertiesComponent propertiesComponent, BlueprintContainer container, PropertiesParser delegate) {
        this.propertiesComponent = propertiesComponent;
        this.container = container;
        this.delegate = delegate;
    }

    public String[] lookupPropertyPlaceholderIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (String componentId : this.container.getComponentIds()) {
            Class clazz;
            String id = componentId;
            ComponentMetadata meta = this.container.getComponentMetadata(id);
            if (!(meta instanceof ExtendedBeanMetadata) || (clazz = ((ExtendedBeanMetadata)meta).getRuntimeClass()) == null || !AbstractPropertyPlaceholder.class.isAssignableFrom(clazz)) continue;
            ids.add(id);
        }
        return ids.toArray(new String[ids.size()]);
    }

    public void addPropertyPlaceholder(String id) {
        Object component = this.container.getComponentInstance(id);
        if (component instanceof AbstractPropertyPlaceholder) {
            AbstractPropertyPlaceholder placeholder = (AbstractPropertyPlaceholder)component;
            this.placeholders.add(placeholder);
            this.log.debug("Adding Blueprint PropertyPlaceholder: {}", (Object)id);
            if (this.method == null) {
                try {
                    this.method = AbstractPropertyPlaceholder.class.getDeclaredMethod("getProperty", String.class);
                    this.method.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Cannot add blueprint property placeholder: " + id + " as the method getProperty is not accessible", e);
                }
            }
        }
    }

    public String parseProperty(String key, String value, Properties properties) {
        String delegateAnswer;
        this.log.trace("Parsing property key: {} with value: {}", (Object)key, (Object)value);
        String answer = null;
        if (key != null && this.propertiesComponent.getOverrideProperties() != null) {
            answer = (String)this.propertiesComponent.getOverrideProperties().get(key);
        }
        if (answer == null && key != null) {
            for (AbstractPropertyPlaceholder placeholder : this.placeholders) {
                answer = (String)ObjectHelper.invokeMethod((Method)this.method, (Object)placeholder, (Object[])new Object[]{key});
                if (answer == null) continue;
                this.log.debug("Blueprint parsed property key: {} as value: {}", (Object)key, (Object)answer);
                break;
            }
        }
        if (this.delegate != null && (delegateAnswer = this.delegate.parseProperty(key, answer != null ? answer : value, properties)) != null) {
            answer = delegateAnswer;
        }
        this.log.trace("Returning parsed property key: {} as value: {}", (Object)key, (Object)answer);
        return answer;
    }
}

