/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.NumberPatternFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class ShortPatternFormatFactory
extends AbstractFormatFactory {
    public ShortPatternFormatFactory() {
        this.supportedClasses.add(Short.TYPE);
        this.supportedClasses.add(Short.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isNotEmpty((String)formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new ShortPatternFormat(formattingOptions.getPattern(), formattingOptions.getLocale());
    }

    private static class ShortPatternFormat
    extends NumberPatternFormat<Short> {
        ShortPatternFormat(String pattern, Locale locale) {
            super(pattern, locale);
        }

        @Override
        public Short parse(String string) throws Exception {
            if (this.getNumberFormat() != null) {
                return this.getNumberFormat().parse(string).shortValue();
            }
            return Short.valueOf(string);
        }
    }
}

