/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.PatternFormat;
import org.apache.camel.dataformat.bindy.format.FormatException;
import org.apache.camel.util.ObjectHelper;

public class DatePatternFormat
implements PatternFormat<Date> {
    private String pattern;
    private Locale locale = Locale.getDefault();

    public DatePatternFormat() {
    }

    public DatePatternFormat(String pattern, Locale locale) {
        this.pattern = pattern;
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    @Override
    public String format(Date object) throws Exception {
        ObjectHelper.notNull((Object)this.pattern, (String)"pattern");
        return this.getDateFormat().format(object);
    }

    @Override
    public Date parse(String string) throws Exception {
        DateFormat df = this.getDateFormat();
        ObjectHelper.notNull((Object)this.pattern, (String)"pattern");
        if (string.length() <= this.pattern.length()) {
            df.setLenient(false);
            Date date = df.parse(string);
            return date;
        }
        throw new FormatException("Date provided does not fit the pattern defined");
    }

    protected DateFormat getDateFormat() {
        return new SimpleDateFormat(this.pattern, this.locale);
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

