/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.NumberPatternFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class DoublePatternFormatFactory
extends AbstractFormatFactory {
    public DoublePatternFormatFactory() {
        this.supportedClasses.add(Double.TYPE);
        this.supportedClasses.add(Double.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isNotEmpty((Object)formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new DoublePatternFormat(formattingOptions.getPattern(), formattingOptions.getLocale());
    }

    private static class DoublePatternFormat
    extends NumberPatternFormat<Double> {
        DoublePatternFormat(String pattern, Locale locale) {
            super(pattern, locale);
        }

        @Override
        public Double parse(String string) throws Exception {
            if (this.getNumberFormat() != null) {
                return this.getNumberFormat().parse(string).doubleValue();
            }
            return Double.valueOf(string);
        }
    }
}

